/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class CompletionStages {
    public static <T> CompletionStage<T> completedStage(T value) {
        return CompletableFuture.completedFuture(value);
    }

    public static <T> CompletionStage<T> failedStage(Throwable exception) {
        return CompletionStages.failedFuture(exception);
    }

    public static <T> CompletableFuture<T> failedFuture(Throwable exception) {
        CompletableFuture result = new CompletableFuture();
        result.completeExceptionally(exception);
        return result;
    }

    public static <T> void propagateCompletion(CompletionStage<T> from, CompletableFuture<T> to) {
        from.whenComplete((value, exception) -> {
            if (exception == null) {
                to.complete(value);
            } else {
                to.completeExceptionally((Throwable)exception);
            }
        });
    }
}

