/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.dataobject;

import io.smallrye.openapi.api.models.media.SchemaImpl;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.io.schema.SchemaFactory;
import io.smallrye.openapi.runtime.scanner.OpenApiDataObjectScanner;
import io.smallrye.openapi.runtime.scanner.SchemaRegistry;
import io.smallrye.openapi.runtime.scanner.dataobject.AugmentedIndexView;
import io.smallrye.openapi.runtime.scanner.dataobject.DataObjectDeque;
import io.smallrye.openapi.runtime.scanner.dataobject.DataObjectLogging;
import io.smallrye.openapi.runtime.scanner.dataobject.TypeResolver;
import io.smallrye.openapi.runtime.util.TypeUtil;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

public class TypeProcessor {
    private final Schema schema;
    private final AugmentedIndexView index;
    private final ClassLoader cl;
    private final AnnotationTarget annotationTarget;
    private final DataObjectDeque objectStack;
    private final TypeResolver typeResolver;
    private final DataObjectDeque.PathEntry parentPathEntry;
    private Type type;

    public TypeProcessor(AugmentedIndexView index, ClassLoader cl, DataObjectDeque objectStack, DataObjectDeque.PathEntry parentPathEntry, TypeResolver typeResolver, Type type, Schema schema, AnnotationTarget annotationTarget) {
        this.objectStack = objectStack;
        this.typeResolver = typeResolver;
        this.parentPathEntry = parentPathEntry;
        this.type = type;
        this.schema = schema;
        this.index = index;
        this.cl = cl;
        this.annotationTarget = annotationTarget;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Type processType() {
        if (TypeUtil.isTerminalType(this.type)) {
            return this.type;
        }
        if (this.type.kind() == Type.Kind.WILDCARD_TYPE) {
            this.type = TypeUtil.resolveWildcard(this.type.asWildcardType());
        }
        if (this.type.kind() == Type.Kind.TYPE_VARIABLE || this.type.kind() == Type.Kind.UNRESOLVED_TYPE_VARIABLE) {
            this.type = this.resolveTypeVariable(this.schema, this.type, false);
        }
        if (this.type.kind() == Type.Kind.ARRAY) {
            DataObjectLogging.log.processingArray(this.type);
            ArrayType arrayType = this.type.asArrayType();
            SchemaImpl arrSchema = new SchemaImpl();
            this.schema.type(Schema.SchemaType.ARRAY);
            TypeUtil.applyTypeAttributes(arrayType.component(), arrSchema);
            if (!TypeUtil.isTerminalType(arrayType.component()) && this.index.containsClass(this.type)) {
                this.pushToStack(this.type, arrSchema);
            }
            arrSchema = SchemaRegistry.checkRegistration(arrayType.component(), this.typeResolver, arrSchema);
            while (arrayType.dimensions() > 1) {
                SchemaImpl parentArrSchema = new SchemaImpl();
                parentArrSchema.setType(Schema.SchemaType.ARRAY);
                parentArrSchema.items(arrSchema);
                arrSchema = parentArrSchema;
                arrayType = ArrayType.create((Type)arrayType.component(), (int)(arrayType.dimensions() - 1));
            }
            this.schema.items((Schema)arrSchema);
            return arrayType;
        }
        if (TypeUtil.isOptional(this.type)) {
            Type optType = TypeUtil.getOptionalType(this.type);
            if (!TypeUtil.isTerminalType(optType) && this.index.containsClass(optType)) {
                this.pushToStack(optType);
            }
            return optType;
        }
        if (this.isA(this.type, OpenApiDataObjectScanner.ENUM_TYPE) && this.index.containsClass(this.type)) {
            MergeUtil.mergeObjects(this.schema, SchemaFactory.enumToSchema(this.index, this.cl, this.type));
            return OpenApiDataObjectScanner.STRING_TYPE;
        }
        if (this.type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            return this.readParameterizedType(this.type.asParameterizedType());
        }
        if (this.isA(this.type, OpenApiDataObjectScanner.COLLECTION_TYPE)) {
            return OpenApiDataObjectScanner.ARRAY_TYPE_OBJECT;
        }
        if (this.isA(this.type, OpenApiDataObjectScanner.ITERABLE_TYPE)) {
            return OpenApiDataObjectScanner.ARRAY_TYPE_OBJECT;
        }
        if (this.isA(this.type, OpenApiDataObjectScanner.MAP_TYPE)) {
            return OpenApiDataObjectScanner.OBJECT_TYPE;
        }
        if (this.index.containsClass(this.type)) {
            this.pushToStack(this.type);
        } else {
            DataObjectLogging.log.typeNotInJandexIndex(this.type);
        }
        return this.type;
    }

    private Type readParameterizedType(ParameterizedType pType) {
        DataObjectLogging.log.processingParametrizedType(pType);
        ParameterizedType typeRead = pType;
        if (this.isA((Type)pType, OpenApiDataObjectScanner.COLLECTION_TYPE) || this.isA((Type)pType, OpenApiDataObjectScanner.ITERABLE_TYPE)) {
            Type arg;
            DataObjectLogging.log.processingTypeAs("Java Collection", "Array");
            SchemaImpl arraySchema = new SchemaImpl();
            this.schema.type(Schema.SchemaType.ARRAY);
            if (TypeUtil.isA(this.index, this.cl, (Type)pType, OpenApiDataObjectScanner.SET_TYPE)) {
                this.schema.setUniqueItems(Boolean.TRUE);
            }
            if (TypeUtil.isTerminalType(arg = (Type)pType.arguments().get(0))) {
                TypeUtil.applyTypeAttributes(arg, arraySchema);
            } else {
                arraySchema = this.resolveParameterizedType(arg, arraySchema);
            }
            this.schema.items((Schema)arraySchema);
            typeRead = OpenApiDataObjectScanner.ARRAY_TYPE_OBJECT;
        } else if (this.isA((Type)pType, OpenApiDataObjectScanner.MAP_TYPE)) {
            DataObjectLogging.log.processingTypeAs("Map", "object");
            this.schema.type(Schema.SchemaType.OBJECT);
            if (pType.arguments().size() == 2) {
                Type valueType = (Type)pType.arguments().get(1);
                SchemaImpl propsSchema = new SchemaImpl();
                if (TypeUtil.isTerminalType(valueType)) {
                    TypeUtil.applyTypeAttributes(valueType, propsSchema);
                } else {
                    propsSchema = this.resolveParameterizedType(valueType, propsSchema);
                }
                this.schema.additionalPropertiesSchema((Schema)propsSchema);
            }
            typeRead = OpenApiDataObjectScanner.OBJECT_TYPE;
        } else if (this.index.containsClass(this.type)) {
            this.pushToStack((Type)pType);
        }
        return typeRead;
    }

    private Schema resolveParameterizedType(Type valueType, Schema propsSchema) {
        if (valueType.kind() == Type.Kind.TYPE_VARIABLE || valueType.kind() == Type.Kind.UNRESOLVED_TYPE_VARIABLE || valueType.kind() == Type.Kind.WILDCARD_TYPE) {
            Type resolved = this.resolveTypeVariable(propsSchema, valueType, true);
            if (this.index.containsClass(resolved)) {
                propsSchema.type(Schema.SchemaType.OBJECT);
                propsSchema = SchemaRegistry.checkRegistration(valueType, this.typeResolver, propsSchema);
            }
        } else if (this.index.containsClass(valueType)) {
            if (this.isA(valueType, OpenApiDataObjectScanner.ENUM_TYPE)) {
                DataObjectLogging.log.processingEnum(this.type);
                propsSchema = SchemaFactory.enumToSchema(this.index, this.cl, valueType);
            } else {
                propsSchema.type(Schema.SchemaType.OBJECT);
                this.pushToStack(valueType, propsSchema);
            }
            propsSchema = SchemaRegistry.checkRegistration(valueType, this.typeResolver, propsSchema);
        }
        return propsSchema;
    }

    private Type resolveTypeVariable(Schema schema, Type fieldType, boolean pushToStack) {
        Type resolvedType = this.typeResolver.getResolvedType(fieldType);
        DataObjectLogging.log.resolvedType(fieldType, resolvedType);
        if (TypeUtil.isTerminalType(resolvedType) || !this.index.containsClass(resolvedType)) {
            DataObjectLogging.log.terminalType(resolvedType);
            TypeUtil.applyTypeAttributes(resolvedType, schema);
        } else if (pushToStack) {
            this.objectStack.push(this.annotationTarget, this.parentPathEntry, resolvedType, schema);
        }
        return resolvedType;
    }

    private void pushToStack(Type fieldType) {
        this.objectStack.push(this.annotationTarget, this.parentPathEntry, fieldType, this.schema);
    }

    private void pushToStack(Type resolvedType, Schema schema) {
        this.objectStack.push(this.annotationTarget, this.parentPathEntry, resolvedType, schema);
    }

    private boolean isA(Type testSubject, Type test) {
        return TypeUtil.isA(this.index, this.cl, testSubject, test);
    }
}

