/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.UndertowServletLogger;
import io.undertow.servlet.api.SessionPersistenceManager;
import io.undertow.servlet.core.Lifecycle;
import io.undertow.servlet.handlers.SecurityActions;
import io.undertow.servlet.spec.HttpSessionImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionEvent;

public class SessionRestoringHandler
implements HttpHandler,
Lifecycle {
    private final String deploymentName;
    private final Map<String, SessionPersistenceManager.PersistentSession> data;
    private final SessionManager sessionManager;
    private final ServletContextImpl servletContext;
    private final HttpHandler next;
    private final SessionPersistenceManager sessionPersistenceManager;
    private volatile boolean started = false;

    public SessionRestoringHandler(String deploymentName, SessionManager sessionManager, ServletContextImpl servletContext, HttpHandler next, SessionPersistenceManager sessionPersistenceManager) {
        this.deploymentName = deploymentName;
        this.sessionManager = sessionManager;
        this.servletContext = servletContext;
        this.next = next;
        this.sessionPersistenceManager = sessionPersistenceManager;
        this.data = new ConcurrentHashMap<String, SessionPersistenceManager.PersistentSession>();
    }

    @Override
    public void start() {
        ClassLoader old = this.getTccl();
        try {
            this.setTccl(this.servletContext.getClassLoader());
            try {
                Map<String, SessionPersistenceManager.PersistentSession> sessionData = this.sessionPersistenceManager.loadSessionAttributes(this.deploymentName, this.servletContext.getClassLoader());
                if (sessionData != null) {
                    this.data.putAll(sessionData);
                }
            }
            catch (Exception e) {
                UndertowServletLogger.ROOT_LOGGER.failedtoLoadPersistentSessions(e);
            }
            this.started = true;
        }
        finally {
            this.setTccl(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        ClassLoader old = this.getTccl();
        try {
            this.setTccl(this.servletContext.getClassLoader());
            this.started = false;
            HashMap<String, SessionPersistenceManager.PersistentSession> objectData = new HashMap<String, SessionPersistenceManager.PersistentSession>();
            for (String sessionId : this.sessionManager.getTransientSessions()) {
                Session session = this.sessionManager.getSession(sessionId);
                if (session == null) continue;
                HttpSessionEvent event = new HttpSessionEvent((HttpSession)SecurityActions.forSession(session, this.servletContext, false));
                HashMap<String, Object> sessionData = new HashMap<String, Object>();
                for (String attr : session.getAttributeNames()) {
                    Object attribute = session.getAttribute(attr);
                    sessionData.put(attr, attribute);
                    if (!(attribute instanceof HttpSessionActivationListener)) continue;
                    ((HttpSessionActivationListener)attribute).sessionWillPassivate(event);
                }
                objectData.put(sessionId, new SessionPersistenceManager.PersistentSession(new Date(session.getLastAccessedTime() + (long)(session.getMaxInactiveInterval() * 1000)), sessionData));
            }
            this.sessionPersistenceManager.persistSessions(this.deploymentName, objectData);
            this.data.clear();
        }
        finally {
            this.setTccl(old);
        }
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        long time;
        String incomingSessionId = this.servletContext.getSessionConfig().findSessionId(exchange);
        if (incomingSessionId == null || !this.data.containsKey(incomingSessionId)) {
            this.next.handleRequest(exchange);
            return;
        }
        SessionPersistenceManager.PersistentSession result = this.data.remove(incomingSessionId);
        if (result != null && (time = System.currentTimeMillis()) < result.getExpiration().getTime()) {
            HttpSessionImpl session = this.servletContext.getSession(exchange, true);
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)session);
            for (Map.Entry<String, Object> entry : result.getSessionData().entrySet()) {
                if (entry.getValue() instanceof HttpSessionActivationListener) {
                    ((HttpSessionActivationListener)entry.getValue()).sessionDidActivate(event);
                }
                if (entry.getKey().startsWith("io.undertow")) {
                    session.getSession().setAttribute(entry.getKey(), entry.getValue());
                    continue;
                }
                session.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        this.next.handleRequest(exchange);
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    private ClassLoader getTccl() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private void setTccl(final ClassLoader classLoader) {
        if (System.getSecurityManager() == null) {
            Thread.currentThread().setContextClassLoader(classLoader);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    return null;
                }
            });
        }
    }
}

