/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.engine.impl.AnalyzerRegistry;
import org.hibernate.search.util.impl.Closeables;

public class ImmutableAnalyzerRegistry
implements AnalyzerRegistry {
    private final AnalyzerReference defaultReference;
    private final AnalyzerReference passThroughReference;
    private final Map<String, AnalyzerReference> referencesByName;
    private final Map<Class<?>, AnalyzerReference> referencesByClass;
    private final Collection<AnalyzerReference> scopedReferences;

    ImmutableAnalyzerRegistry(AnalyzerRegistry registryState) {
        this.defaultReference = registryState.getDefaultAnalyzerReference();
        this.passThroughReference = registryState.getPassThroughAnalyzerReference();
        this.referencesByName = Collections.unmodifiableMap(new HashMap<String, AnalyzerReference>(registryState.getNamedAnalyzerReferences()));
        this.referencesByClass = Collections.unmodifiableMap(new HashMap(registryState.getLuceneClassAnalyzerReferences()));
        this.scopedReferences = Collections.unmodifiableList(new ArrayList<AnalyzerReference>(registryState.getScopedAnalyzerReferences()));
    }

    @Override
    public AnalyzerReference getDefaultAnalyzerReference() {
        return this.defaultReference;
    }

    @Override
    public AnalyzerReference getPassThroughAnalyzerReference() {
        return this.passThroughReference;
    }

    @Override
    public Map<String, AnalyzerReference> getNamedAnalyzerReferences() {
        return this.referencesByName;
    }

    @Override
    public Map<Class<?>, AnalyzerReference> getLuceneClassAnalyzerReferences() {
        return this.referencesByClass;
    }

    @Override
    public Collection<AnalyzerReference> getScopedAnalyzerReferences() {
        return this.scopedReferences;
    }

    @Override
    public AnalyzerReference getAnalyzerReference(String name) {
        return this.referencesByName.get(name);
    }

    @Override
    public AnalyzerReference getAnalyzerReference(Class<?> analyzerClazz) {
        return this.referencesByClass.get(analyzerClazz);
    }

    @Override
    public void close() {
        Closeables.closeQuietly(this.defaultReference);
        Closeables.closeQuietly(this.passThroughReference);
        Closeables.closeQuietly(this.referencesByName.values(), this.referencesByClass.values(), this.scopedReferences);
    }
}

