/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util;

import java.io.IOException;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.Function;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.ObjectMarshaller;
import org.wildfly.clustering.marshalling.protostream.Predictable;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;

public abstract class MapMarshaller<T extends Map<Object, Object>, C>
implements ProtoStreamMarshaller<T> {
    private final Class<T> targetClass;
    private final Function<C, T> factory;
    private final Function<T, C> context;
    private final ProtoStreamMarshaller<C> contextMarshaller;

    public MapMarshaller(Class<?> targetClass, Function<C, T> factory, Function<T, C> context, ProtoStreamMarshaller<C> contextMarshaller) {
        this.targetClass = targetClass;
        this.factory = factory;
        this.context = context;
        this.contextMarshaller = contextMarshaller;
    }

    public T readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
        Object mapContext = this.contextMarshaller.readFrom(context, reader);
        Map map = (Map)this.factory.apply(mapContext);
        int size = reader.readUInt32();
        for (int i = 0; i < size; ++i) {
            map.put(ObjectMarshaller.INSTANCE.readFrom(context, reader), ObjectMarshaller.INSTANCE.readFrom(context, reader));
        }
        return (T)map;
    }

    public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, T map) throws IOException {
        C mapContext = this.context.apply(map);
        this.contextMarshaller.writeTo(context, writer, mapContext);
        writer.writeUInt32NoTag(map.size());
        for (Map.Entry entry : map.entrySet()) {
            ObjectMarshaller.INSTANCE.writeTo(context, writer, entry.getKey());
            ObjectMarshaller.INSTANCE.writeTo(context, writer, entry.getValue());
        }
    }

    @Override
    public OptionalInt size(ImmutableSerializationContext context, T map) {
        C mapContext = this.context.apply(map);
        OptionalInt size = this.contextMarshaller.size(context, mapContext);
        if (size.isPresent()) {
            size = OptionalInt.of(size.getAsInt() + Predictable.unsignedIntSize(map.size()));
            for (Map.Entry entry : map.entrySet()) {
                OptionalInt keySize = ObjectMarshaller.INSTANCE.size(context, entry.getKey());
                OptionalInt valueSize = ObjectMarshaller.INSTANCE.size(context, entry.getValue());
                size = size.isPresent() && keySize.isPresent() && valueSize.isPresent() ? OptionalInt.of(size.getAsInt() + keySize.getAsInt() + valueSize.getAsInt()) : OptionalInt.empty();
            }
        }
        return size;
    }

    public Class<? extends T> getJavaClass() {
        return this.targetClass;
    }
}

