/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2020, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.wildfly.clustering.marshalling.spi;

import java.util.function.Function;

/**
 * Behaves the same as {@link Function#identity()}, where the return type is a superclass of the function parameter.
 * @author Paul Ferraro
 */
public enum IdentityFunction implements Function<Object, Object> {
    INSTANCE;

    @Override
    public Object apply(Object value) {
        return value;
    }

    /**
     * Returns a function that returns its parameter.
     * @param <T> the parameter type
     * @param <R> the return type
     * @return a function that return its parameter
     */
    @SuppressWarnings("unchecked")
    public static <T extends R, R> Function<T, R> getInstance() {
        return (Function<T, R>) INSTANCE;
    }
}
