/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server.security;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.Principal;
import javax.security.auth.Subject;
import org.jboss.as.controller.security.InetAddressPrincipal;
import org.jboss.as.core.security.RealmUser;
import org.jboss.as.domain.http.server.security.RealmIdentityAccount;

public class AnonymousMechanism
implements AuthenticationMechanism {
    private static final String ANONYMOUS_USER = "anonymous";
    private static final String ANONYMOUS_MECH = "ANONYMOUS";

    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext context) {
        RealmUser user = new RealmUser(ANONYMOUS_USER);
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)user);
        SocketAddress address = exchange.getConnection().getPeerAddress();
        if (address instanceof InetSocketAddress) {
            subject.getPrincipals().add((Principal)new InetAddressPrincipal(((InetSocketAddress)address).getAddress()));
        }
        context.authenticationComplete((Account)new RealmIdentityAccount(subject, (Principal)user), ANONYMOUS_MECH, false);
        return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange arg0, SecurityContext arg1) {
        return new AuthenticationMechanism.ChallengeResult(false);
    }
}

