/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.build.spi;

import io.smallrye.jwt.build.JwtClaimsBuilder;
import io.smallrye.jwt.build.JwtException;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;

public abstract class JwtProvider {
    private static final String DEFAULT_JWT_PROVIDER = "io.smallrye.jwt.build.impl.JwtProviderImpl";

    protected JwtProvider() {
    }

    public static JwtProvider provider() {
        ServiceLoader<JwtProvider> loader = ServiceLoader.load(JwtProvider.class);
        Iterator<JwtProvider> it = loader.iterator();
        if (it.hasNext()) {
            return it.next();
        }
        try {
            return (JwtProvider)Class.forName(DEFAULT_JWT_PROVIDER).newInstance();
        }
        catch (ClassNotFoundException ex) {
            throw new JwtException("JwtProvider io.smallrye.jwt.build.impl.JwtProviderImpl has not been found", ex);
        }
        catch (IllegalAccessException ex) {
            throw new JwtException("JwtProvider io.smallrye.jwt.build.impl.JwtProviderImpl class could not be accessed: " + ex, ex);
        }
        catch (InstantiationException ex) {
            throw new JwtException("JwtProvider io.smallrye.jwt.build.impl.JwtProviderImpl could not be instantiated: " + ex, ex);
        }
    }

    public abstract JwtClaimsBuilder claims();

    public abstract JwtClaimsBuilder claims(Map<String, Object> var1);

    public abstract JwtClaimsBuilder claims(String var1);
}

