/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.local;

import io.reactivex.rxjava3.core.Flowable;
import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.infinispan.AdvancedCache;
import org.infinispan.BaseCacheStream;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.cache.impl.AbstractDelegatingCache;
import org.infinispan.commons.util.Closeables;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IteratorMapper;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.context.Flag;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.stream.impl.local.AbstractLocalCacheStream;
import org.infinispan.util.LazyConcatIterator;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;

public class PersistenceEntryStreamSupplier<K, V>
implements AbstractLocalCacheStream.StreamSupplier<CacheEntry<K, V>, Stream<CacheEntry<K, V>>> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final boolean trace = log.isTraceEnabled();
    private final Cache<K, V> cache;
    private final InternalEntryFactory iceFactory;
    private final ToIntFunction<Object> toIntFunction;
    private final CacheStream<CacheEntry<K, V>> inMemoryStream;
    private final PersistenceManager persistenceManager;

    public PersistenceEntryStreamSupplier(Cache<K, V> cache, InternalEntryFactory iceFactory, ToIntFunction<Object> toIntFunction, CacheStream<CacheEntry<K, V>> inMemoryStream, PersistenceManager persistenceManager) {
        this.cache = cache;
        this.iceFactory = iceFactory;
        this.toIntFunction = toIntFunction;
        this.inMemoryStream = inMemoryStream;
        this.persistenceManager = persistenceManager;
    }

    @Override
    public Stream<CacheEntry<K, V>> buildStream(IntSet segmentsToFilter, Set<?> keysToFilter, boolean parallel) {
        Stream stream;
        if (keysToFilter != null) {
            if (trace) {
                log.tracef("Applying key filtering %s", keysToFilter);
            }
            AdvancedCache<K, V> advancedCache = AbstractDelegatingCache.unwrapCache(this.cache).getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL);
            stream = keysToFilter.stream().map(advancedCache::getCacheEntry).filter(Objects::nonNull);
            if (segmentsToFilter != null && this.toIntFunction != null) {
                if (trace) {
                    log.tracef("Applying segment filter %s", segmentsToFilter);
                }
                stream = stream.filter(k -> {
                    Object key = k.getKey();
                    int segment = this.toIntFunction.applyAsInt(key);
                    boolean isPresent = segmentsToFilter.contains(segment);
                    if (trace) {
                        log.tracef("Is key %s present in segment %d? %b", key, segment, isPresent);
                    }
                    return isPresent;
                });
            }
        } else {
            Publisher publisher;
            BaseCacheStream inMemoryStream = this.inMemoryStream;
            HashSet seenKeys = new HashSet(2048);
            if (segmentsToFilter != null) {
                inMemoryStream = inMemoryStream.filterKeySegments(segmentsToFilter);
                publisher = this.persistenceManager.publishEntries(segmentsToFilter, k -> !seenKeys.contains(k), true, true, PersistenceManager.AccessMode.BOTH);
            } else {
                publisher = this.persistenceManager.publishEntries(k -> !seenKeys.contains(k), true, true, PersistenceManager.AccessMode.BOTH);
            }
            IteratorMapper localIterator = new IteratorMapper((Iterator)Closeables.iterator(inMemoryStream), e -> {
                seenKeys.add(e.getKey());
                return e;
            });
            Flowable flowable = Flowable.fromPublisher(publisher).map(me -> PersistenceUtil.convert(me, this.iceFactory));
            LazyConcatIterator iterator = new LazyConcatIterator(localIterator, () -> org.infinispan.util.Closeables.iterator(flowable, 128));
            Iterable iterable = () -> iterator;
            stream = (Stream)StreamSupport.stream(iterable.spliterator(), parallel).onClose(() -> iterator.close());
        }
        return stream;
    }
}

