/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util.concurrent;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.protostream.ExternalizerMarshaller;
import org.wildfly.clustering.marshalling.protostream.MarshallerProvider;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.HashMapMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.HashSetMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.SortedMapMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.SortedSetMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.UnboundedCollectionMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.concurrent.CopyOnWriteCollectionMarshaller;

public enum ConcurrentMarshaller implements MarshallerProvider
{
    CONCURRENT_HASH_MAP(new HashMapMarshaller<ConcurrentHashMap>(ConcurrentHashMap.class, ConcurrentHashMap::new)),
    CONCURRENT_HASH_SET((Externalizer<?>)new HashSetMarshaller<ConcurrentHashMap.KeySetView>(ConcurrentHashMap.KeySetView.class, ConcurrentHashMap::newKeySet)),
    CONCURRENT_LINKED_DEQUE(new UnboundedCollectionMarshaller<ConcurrentLinkedDeque>(ConcurrentLinkedDeque.class, ConcurrentLinkedDeque::new)),
    CONCURRENT_LINKED_QUEUE(new UnboundedCollectionMarshaller<ConcurrentLinkedQueue>(ConcurrentLinkedQueue.class, ConcurrentLinkedQueue::new)),
    CONCURRENT_SKIP_LIST_MAP(new SortedMapMarshaller<ConcurrentSkipListMap>(ConcurrentSkipListMap.class, ConcurrentSkipListMap::new)),
    CONCURRENT_SKIP_LIST_SET(new SortedSetMarshaller<ConcurrentSkipListSet>(ConcurrentSkipListSet.class, ConcurrentSkipListSet::new)),
    COPY_ON_WRITE_ARRAY_LIST(new CopyOnWriteCollectionMarshaller<CopyOnWriteArrayList>(CopyOnWriteArrayList.class, CopyOnWriteArrayList::new)),
    COPY_ON_WRITE_ARRAY_SET(new CopyOnWriteCollectionMarshaller<CopyOnWriteArraySet>(CopyOnWriteArraySet.class, CopyOnWriteArraySet::new));

    private final ProtoStreamMarshaller<Object> marshaller;

    private ConcurrentMarshaller(ProtoStreamMarshaller<?> marshaller) {
        this.marshaller = marshaller;
    }

    private ConcurrentMarshaller(Externalizer<?> externalizer) {
        this(new ExternalizerMarshaller(externalizer));
    }

    @Override
    public ProtoStreamMarshaller<?> getMarshaller() {
        return this.marshaller;
    }
}

