/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.federation.queue;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationQueuePolicyConfiguration;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.filter.impl.FilterImpl;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.federation.FederatedAbstract;
import org.apache.activemq.artemis.core.server.federation.FederatedConsumerKey;
import org.apache.activemq.artemis.core.server.federation.Federation;
import org.apache.activemq.artemis.core.server.federation.FederationUpstream;
import org.apache.activemq.artemis.core.server.federation.queue.FederatedQueueConsumerKey;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerConsumerPlugin;
import org.apache.activemq.artemis.core.server.transformer.Transformer;
import org.apache.activemq.artemis.core.settings.impl.Match;

public class FederatedQueue
extends FederatedAbstract
implements ActiveMQServerConsumerPlugin,
Serializable {
    private final Set<Matcher> includes;
    private final Set<Matcher> excludes;
    private final Filter metaDataFilter;
    private final int priorityAdjustment;
    private final FederationQueuePolicyConfiguration config;

    public FederatedQueue(Federation federation, FederationQueuePolicyConfiguration config, ActiveMQServer server, FederationUpstream federationUpstream) throws ActiveMQException {
        super(federation, server, federationUpstream);
        Objects.requireNonNull(config.getName());
        this.config = config;
        this.priorityAdjustment = federationUpstream.getPriorityAdjustment() + (config.getPriorityAdjustment() == null ? -1 : config.getPriorityAdjustment());
        String metaDataFilterString = config.isIncludeFederated() ? null : "federation-name IS NOT NULL";
        this.metaDataFilter = FilterImpl.createFilter(metaDataFilterString);
        if (config.getIncludes().isEmpty()) {
            this.includes = Collections.emptySet();
        } else {
            this.includes = new HashSet<Matcher>(config.getIncludes().size());
            for (FederationQueuePolicyConfiguration.Matcher include : config.getIncludes()) {
                this.includes.add(new Matcher(include, this.wildcardConfiguration));
            }
        }
        if (config.getExcludes().isEmpty()) {
            this.excludes = Collections.emptySet();
        } else {
            this.excludes = new HashSet<Matcher>(config.getExcludes().size());
            for (FederationQueuePolicyConfiguration.Matcher exclude : config.getExcludes()) {
                this.excludes.add(new Matcher(exclude, this.wildcardConfiguration));
            }
        }
    }

    @Override
    public void start() {
        super.start();
        this.server.getPostOffice().getAllBindings().values().stream().filter(b -> b instanceof QueueBinding).map(b -> (QueueBinding)b).forEach(b -> this.createRemoteConsumer(b.getQueue()));
    }

    @Override
    public synchronized void afterCreateConsumer(ServerConsumer consumer) {
        this.createRemoteConsumer(consumer);
    }

    public FederationQueuePolicyConfiguration getConfig() {
        return this.config;
    }

    private void createRemoteConsumer(Queue queue) {
        queue.getConsumers().stream().filter(consumer -> consumer instanceof ServerConsumer).map(c -> (ServerConsumer)c).forEach(this::createRemoteConsumer);
    }

    private void createRemoteConsumer(ServerConsumer consumer) {
        ServerSession serverSession = this.server.getSessionByID(consumer.getSessionID());
        if (this.metaDataFilter != null && serverSession != null && this.metaDataFilter.match(serverSession.getMetaData())) {
            return;
        }
        if (this.match(consumer)) {
            FederatedConsumerKey key = this.getKey(consumer);
            Transformer transformer = this.getTransformer(this.config.getTransformerRef());
            Transformer fqqnTransformer = message -> message == null ? null : message.setAddress(key.getFqqn());
            this.createRemoteConsumer(key, this.mergeTransformers(fqqnTransformer, transformer), null);
        }
    }

    private boolean match(ServerConsumer consumer) {
        for (Matcher exclude : this.excludes) {
            if (!exclude.test(consumer)) continue;
            return false;
        }
        if (this.includes.isEmpty()) {
            return true;
        }
        for (Matcher include : this.includes) {
            if (!include.test(consumer)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void beforeCloseConsumer(ServerConsumer consumer, boolean failed) {
        FederatedConsumerKey key = this.getKey(consumer);
        this.removeRemoteConsumer(key);
    }

    private FederatedConsumerKey getKey(ServerConsumer consumer) {
        Queue queue = consumer.getQueue();
        int priority = consumer.getPriority() + this.priorityAdjustment;
        return new FederatedQueueConsumerKey(queue.getAddress(), queue.getRoutingType(), queue.getName(), Filter.toFilterString(queue.getFilter()), Filter.toFilterString(consumer.getFilter()), priority);
    }

    public static class Matcher {
        Predicate<String> queuePredicate;
        Predicate<String> addressPredicate;

        Matcher(FederationQueuePolicyConfiguration.Matcher config, WildcardConfiguration wildcardConfiguration) {
            if (config.getQueueMatch() != null && !config.getQueueMatch().isEmpty()) {
                this.queuePredicate = new Match<Object>(config.getQueueMatch(), null, wildcardConfiguration).getPattern().asPredicate();
            }
            if (config.getAddressMatch() != null && !config.getAddressMatch().isEmpty()) {
                this.addressPredicate = new Match<Object>(config.getAddressMatch(), null, wildcardConfiguration).getPattern().asPredicate();
            }
        }

        public boolean test(ServerConsumer consumer) {
            return !(this.queuePredicate != null && !this.queuePredicate.test(consumer.getQueueName().toString()) || this.addressPredicate != null && !this.addressPredicate.test(consumer.getQueueAddress().toString()));
        }
    }
}

