/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import org.apache.cxf.Bus;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.apache.cxf.transport.jms.JMSMessageHeadersType;
import org.apache.cxf.transport.jms.util.JMSSender;
import org.apache.cxf.workqueue.AutomaticWorkQueue;
import org.apache.cxf.workqueue.WorkQueue;
import org.apache.cxf.workqueue.WorkQueueManager;

public final class JMSFactory {
    public static final String JMS_DESTINATION_EXECUTOR = "org.apache.cxf.extensions.jms.destination.executor";
    public static final String JMS_CONDUIT_EXECUTOR = "org.apache.cxf.extensions.jms.conduit.executor";
    static final String MESSAGE_ENDPOINT_FACTORY = "MessageEndpointFactory";
    static final String MDB_TRANSACTED_METHOD = "MDBTransactedMethod";

    private JMSFactory() {
    }

    public static JMSSender createJmsSender(JMSConfiguration jmsConfig, JMSMessageHeadersType messageProperties) {
        JMSSender sender = new JMSSender();
        long timeToLive = messageProperties != null && messageProperties.isSetTimeToLive() ? messageProperties.getTimeToLive() : jmsConfig.getTimeToLive();
        sender.setTimeToLive(timeToLive);
        int priority = messageProperties != null && messageProperties.isSetJMSPriority() ? messageProperties.getJMSPriority() : jmsConfig.getPriority();
        sender.setPriority(priority);
        int deliveryMode = messageProperties != null && messageProperties.isSetJMSDeliveryMode() ? messageProperties.getJMSDeliveryMode() : jmsConfig.getDeliveryMode();
        sender.setDeliveryMode(deliveryMode);
        sender.setExplicitQosEnabled(jmsConfig.isExplicitQosEnabled());
        return sender;
    }

    static String getMessageSelector(JMSConfiguration jmsConfig, String conduitId) {
        String staticSelectorPrefix = jmsConfig.getConduitSelectorPrefix();
        String conduitIdSt = jmsConfig.isUseConduitIdSelector() && conduitId != null ? conduitId : "";
        String correlationIdPrefix = staticSelectorPrefix + conduitIdSt;
        return correlationIdPrefix.isEmpty() ? null : "JMSCorrelationID LIKE '" + correlationIdPrefix + "%'";
    }

    public static Connection createConnection(JMSConfiguration jmsConfig) throws JMSException {
        Connection connection;
        String username = jmsConfig.getUserName();
        ConnectionFactory cf = jmsConfig.getConnectionFactory();
        Connection connection2 = connection = username != null ? cf.createConnection(username, jmsConfig.getPassword()) : cf.createConnection();
        if (jmsConfig.getDurableSubscriptionClientId() != null) {
            connection.setClientID(jmsConfig.getDurableSubscriptionClientId());
        }
        return connection;
    }

    public static Executor createWorkQueueExecutor(Bus bus, String name) {
        WorkQueueManager manager = (WorkQueueManager)bus.getExtension(WorkQueueManager.class);
        if (manager != null) {
            AutomaticWorkQueue workQueue1 = manager.getNamedWorkQueue(name);
            AutomaticWorkQueue workQueue = workQueue1 == null ? manager.getAutomaticWorkQueue() : workQueue1;
            return new Executor((WorkQueue)workQueue){
                final /* synthetic */ WorkQueue val$workQueue;
                {
                    this.val$workQueue = workQueue;
                }

                @Override
                public void execute(Runnable command) {
                    this.val$workQueue.execute(command, 0L);
                }
            };
        }
        return Executors.newFixedThreadPool(20);
    }
}

