/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.util.OptionalInt;
import java.util.function.Function;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.ObjectMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;

public class FunctionalObjectMarshaller<T>
implements ProtoStreamMarshaller<T> {
    private final Class<T> targetClass;
    private final Function<Object, T> reader;
    private final Function<T, Object> writer;

    public FunctionalObjectMarshaller(Class<T> targetClass, Function<Object, T> reader, Function<T, Object> writer) {
        this.targetClass = targetClass;
        this.reader = reader;
        this.writer = writer;
    }

    public T readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
        return this.reader.apply(ObjectMarshaller.INSTANCE.readFrom(context, reader));
    }

    public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Object value) throws IOException {
        ObjectMarshaller.INSTANCE.writeTo(context, writer, this.writer.apply(this.targetClass.cast(value)));
    }

    @Override
    public OptionalInt size(ImmutableSerializationContext context, Object value) {
        return ObjectMarshaller.INSTANCE.size(context, this.writer.apply(this.targetClass.cast(value)));
    }

    public Class<? extends T> getJavaClass() {
        return this.targetClass;
    }
}

