/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api.util;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Encoding;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.models.tags.Tag;

public class FilterUtil {
    private FilterUtil() {
    }

    public static final OpenAPI applyFilter(OASFilter filter, OpenAPI model) {
        FilterUtil.filterComponents(filter, model.getComponents());
        FilterUtil.filterPaths(filter, model.getPaths());
        FilterUtil.filterServers(filter, model.getServers());
        FilterUtil.filterTags(filter, model.getTags());
        filter.filterOpenAPI(model);
        return model;
    }

    private static void filterComponents(OASFilter filter, Components model) {
        if (model != null) {
            FilterUtil.filterCallbacks(filter, model.getCallbacks());
            FilterUtil.filterHeaders(filter, model.getHeaders());
            FilterUtil.filterLinks(filter, model.getLinks());
            FilterUtil.filterParameters(filter, model.getParameters());
            FilterUtil.filterRequestBodies(filter, model.getRequestBodies());
            FilterUtil.filterAPIResponses(filter, model.getResponses());
            FilterUtil.filterSchemas(filter, model.getSchemas());
            FilterUtil.filterSecuritySchemes(filter, model.getSecuritySchemes());
        }
    }

    private static void filterCallbacks(OASFilter filter, Map<String, Callback> models) {
        if (models != null) {
            ArrayList<String> keys = new ArrayList<String>(models.keySet());
            for (String key : keys) {
                Callback model = models.get(key);
                FilterUtil.filterCallback(filter, model);
                if (filter.filterCallback(model) != null) continue;
                models.remove(key);
            }
        }
    }

    private static void filterCallback(OASFilter filter, Callback model) {
        if (model != null) {
            ArrayList keys = new ArrayList(model.getPathItems().keySet());
            for (String key : keys) {
                PathItem childModel = model.getPathItem(key);
                FilterUtil.filterPathItem(filter, childModel);
                if (filter.filterPathItem(childModel) != null) continue;
                model.removePathItem(key);
            }
        }
    }

    private static void filterPathItem(OASFilter filter, PathItem model) {
        if (model != null) {
            model.setParameters(FilterUtil.filterParameterList(filter, model.getParameters()));
            FilterUtil.filterOperation(filter, model.getDELETE());
            if (model.getDELETE() != null) {
                model.setDELETE(filter.filterOperation(model.getDELETE()));
            }
            FilterUtil.filterOperation(filter, model.getGET());
            if (model.getGET() != null) {
                model.setGET(filter.filterOperation(model.getGET()));
            }
            FilterUtil.filterOperation(filter, model.getHEAD());
            if (model.getHEAD() != null) {
                model.setHEAD(filter.filterOperation(model.getHEAD()));
            }
            FilterUtil.filterOperation(filter, model.getOPTIONS());
            if (model.getOPTIONS() != null) {
                model.setOPTIONS(filter.filterOperation(model.getOPTIONS()));
            }
            FilterUtil.filterOperation(filter, model.getPATCH());
            if (model.getPATCH() != null) {
                model.setPATCH(filter.filterOperation(model.getPATCH()));
            }
            FilterUtil.filterOperation(filter, model.getPOST());
            if (model.getPOST() != null) {
                model.setPOST(filter.filterOperation(model.getPOST()));
            }
            FilterUtil.filterOperation(filter, model.getPUT());
            if (model.getPUT() != null) {
                model.setPUT(filter.filterOperation(model.getPUT()));
            }
            FilterUtil.filterOperation(filter, model.getTRACE());
            if (model.getTRACE() != null) {
                model.setTRACE(filter.filterOperation(model.getTRACE()));
            }
            FilterUtil.filterServers(filter, model.getServers());
        }
    }

    private static List<Parameter> filterParameterList(OASFilter filter, List<Parameter> models) {
        if (models != null) {
            models = new ArrayList<Parameter>(models);
            ListIterator<Parameter> iterator = models.listIterator();
            while (iterator.hasNext()) {
                Parameter model = iterator.next();
                FilterUtil.filterParameter(filter, model);
                if (filter.filterParameter(model) != null) continue;
                iterator.remove();
            }
        }
        return models;
    }

    private static void filterOperation(OASFilter filter, Operation model) {
        if (model != null) {
            FilterUtil.filterCallbacks(filter, model.getCallbacks());
            model.setParameters(FilterUtil.filterParameterList(filter, model.getParameters()));
            FilterUtil.filterRequestBody(filter, model.getRequestBody());
            if (model.getRequestBody() != null && filter.filterRequestBody(model.getRequestBody()) == null) {
                model.setRequestBody(null);
            }
            if (model.getResponses() != null) {
                FilterUtil.filterAPIResponses(filter, model.getResponses().getAPIResponses());
            }
            FilterUtil.filterServers(filter, model.getServers());
        }
    }

    private static void filterHeaders(OASFilter filter, Map<String, Header> models) {
        if (models != null) {
            ArrayList<String> keys = new ArrayList<String>(models.keySet());
            for (String key : keys) {
                Header model = models.get(key);
                FilterUtil.filterHeader(filter, model);
                if (filter.filterHeader(model) != null) continue;
                models.remove(key);
            }
        }
    }

    private static void filterHeader(OASFilter filter, Header model) {
        if (model != null) {
            FilterUtil.filterContent(filter, model.getContent());
            FilterUtil.filterSchema(filter, model.getSchema());
            if (model.getSchema() != null && filter.filterSchema(model.getSchema()) == null) {
                model.setSchema(null);
            }
        }
    }

    private static void filterContent(OASFilter filter, Content model) {
        if (model != null && model.getMediaTypes() != null) {
            ArrayList keys = new ArrayList(model.getMediaTypes().keySet());
            for (String key : keys) {
                MediaType childModel = model.getMediaType(key);
                FilterUtil.filterMediaType(filter, childModel);
            }
        }
    }

    private static void filterMediaType(OASFilter filter, MediaType model) {
        if (model != null) {
            FilterUtil.filterEncoding(filter, model.getEncoding());
            FilterUtil.filterSchema(filter, model.getSchema());
            if (model.getSchema() != null && filter.filterSchema(model.getSchema()) == null) {
                model.setSchema(null);
            }
        }
    }

    private static void filterEncoding(OASFilter filter, Map<String, Encoding> models) {
        if (models != null) {
            ArrayList<String> keys = new ArrayList<String>(models.keySet());
            for (String key : keys) {
                Encoding model = models.get(key);
                FilterUtil.filterEncoding(filter, model);
            }
        }
    }

    private static void filterEncoding(OASFilter filter, Encoding model) {
        if (model != null) {
            FilterUtil.filterHeaders(filter, model.getHeaders());
        }
    }

    private static void filterLinks(OASFilter filter, Map<String, Link> models) {
        if (models != null) {
            ArrayList<String> keys = new ArrayList<String>(models.keySet());
            for (String key : keys) {
                Link model = models.get(key);
                FilterUtil.filterLink(filter, model);
                if (filter.filterLink(model) != null) continue;
                models.remove(key);
            }
        }
    }

    private static void filterLink(OASFilter filter, Link model) {
        if (model != null && model.getServer() != null && filter.filterServer(model.getServer()) == null) {
            model.setServer(null);
        }
    }

    private static void filterParameters(OASFilter filter, Map<String, Parameter> models) {
        if (models != null) {
            ArrayList<String> keys = new ArrayList<String>(models.keySet());
            for (String key : keys) {
                Parameter model = models.get(key);
                FilterUtil.filterParameter(filter, model);
                if (filter.filterParameter(model) != null) continue;
                models.remove(key);
            }
        }
    }

    private static void filterParameter(OASFilter filter, Parameter model) {
        if (model != null) {
            FilterUtil.filterContent(filter, model.getContent());
            FilterUtil.filterSchema(filter, model.getSchema());
            if (model.getSchema() != null && filter.filterSchema(model.getSchema()) == null) {
                model.setSchema(null);
            }
        }
    }

    private static void filterRequestBodies(OASFilter filter, Map<String, RequestBody> models) {
        if (models != null) {
            ArrayList<String> keys = new ArrayList<String>(models.keySet());
            for (String key : keys) {
                RequestBody model = models.get(key);
                FilterUtil.filterRequestBody(filter, model);
                if (filter.filterRequestBody(model) != null) continue;
                models.remove(key);
            }
        }
    }

    private static void filterRequestBody(OASFilter filter, RequestBody model) {
        if (model != null) {
            FilterUtil.filterContent(filter, model.getContent());
        }
    }

    private static void filterAPIResponses(OASFilter filter, Map<String, APIResponse> models) {
        if (models != null) {
            ArrayList<String> keys = new ArrayList<String>(models.keySet());
            for (String key : keys) {
                APIResponse model = models.get(key);
                FilterUtil.filterAPIResponse(filter, model);
                if (filter.filterAPIResponse(model) != null) continue;
                models.remove(key);
            }
        }
    }

    private static void filterAPIResponse(OASFilter filter, APIResponse model) {
        if (model != null) {
            FilterUtil.filterContent(filter, model.getContent());
            FilterUtil.filterHeaders(filter, model.getHeaders());
            FilterUtil.filterLinks(filter, model.getLinks());
        }
    }

    private static void filterSchemas(OASFilter filter, Map<String, Schema> models) {
        if (models != null) {
            ArrayList<String> keys = new ArrayList<String>(models.keySet());
            for (String key : keys) {
                Schema model = models.get(key);
                FilterUtil.filterSchema(filter, model);
                if (filter.filterSchema(model) != null) continue;
                models.remove(key);
            }
        }
    }

    private static void filterSchema(OASFilter filter, Schema model) {
        if (model != null) {
            Schema ap = model.getAdditionalPropertiesSchema();
            if (ap != null) {
                FilterUtil.filterSchema(filter, ap);
                if (filter.filterSchema(ap) == null) {
                    model.setAdditionalPropertiesSchema((Schema)null);
                }
            }
            FilterUtil.filterSchemaList(filter, model.getAllOf());
            FilterUtil.filterSchemaList(filter, model.getAnyOf());
            FilterUtil.filterSchema(filter, model.getItems());
            if (model.getItems() != null && filter.filterSchema(model.getItems()) == null) {
                model.setItems(null);
            }
            FilterUtil.filterSchema(filter, model.getNot());
            if (model.getNot() != null && filter.filterSchema(model.getNot()) == null) {
                model.setNot(null);
            }
            FilterUtil.filterSchemas(filter, model.getProperties());
        }
    }

    private static void filterSchemaList(OASFilter filter, List<Schema> models) {
        if (models != null) {
            ListIterator<Schema> iterator = models.listIterator();
            while (iterator.hasNext()) {
                Schema model = iterator.next();
                FilterUtil.filterSchema(filter, model);
                if (filter.filterSchema(model) != null) continue;
                iterator.remove();
            }
        }
    }

    private static void filterSecuritySchemes(OASFilter filter, Map<String, SecurityScheme> models) {
        if (models != null) {
            ArrayList<String> keys = new ArrayList<String>(models.keySet());
            for (String key : keys) {
                SecurityScheme model = models.get(key);
                if (filter.filterSecurityScheme(model) != null) continue;
                models.remove(key);
            }
        }
    }

    private static void filterPaths(OASFilter filter, Paths model) {
        if (model != null) {
            ArrayList keys = new ArrayList(model.getPathItems().keySet());
            for (String key : keys) {
                PathItem childModel = model.getPathItem(key);
                FilterUtil.filterPathItem(filter, childModel);
                if (filter.filterPathItem(childModel) != null) continue;
                model.removePathItem(key);
            }
        }
    }

    private static void filterServers(OASFilter filter, List<Server> models) {
        if (models != null) {
            ListIterator<Server> iterator = models.listIterator();
            while (iterator.hasNext()) {
                Server model = iterator.next();
                if (filter.filterServer(model) != null) continue;
                iterator.remove();
            }
        }
    }

    private static void filterTags(OASFilter filter, List<Tag> models) {
        if (models != null) {
            ListIterator<Tag> iterator = models.listIterator();
            while (iterator.hasNext()) {
                Tag model = iterator.next();
                if ((model = filter.filterTag(model)) != null) continue;
                iterator.remove();
            }
        }
    }
}

