/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import org.jboss.as.network.ClientMapping;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.IndexSerializer;
import org.wildfly.clustering.marshalling.spi.net.NetExternalizerProvider;

public class ClientMappingExternalizer
implements Externalizer<ClientMapping> {
    private static final Externalizer<InetAddress> ADDRESS_EXTERNALIZER = NetExternalizerProvider.INET_ADDRESS.cast(InetAddress.class);

    public void writeObject(ObjectOutput output, ClientMapping mapping) throws IOException {
        ADDRESS_EXTERNALIZER.writeObject(output, (Object)mapping.getSourceNetworkAddress());
        IndexSerializer.UNSIGNED_BYTE.writeInt((DataOutput)output, mapping.getSourceNetworkMaskBits());
        output.writeUTF(mapping.getDestinationAddress());
        IndexSerializer.UNSIGNED_SHORT.writeInt((DataOutput)output, mapping.getDestinationPort());
    }

    public ClientMapping readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        InetAddress sourceAddress = (InetAddress)ADDRESS_EXTERNALIZER.readObject(input);
        int sourceNetworkMaskBits = IndexSerializer.UNSIGNED_BYTE.readInt((DataInput)input);
        String destAddress = input.readUTF();
        int destPort = IndexSerializer.UNSIGNED_SHORT.readInt((DataInput)input);
        return new ClientMapping(sourceAddress, sourceNetworkMaskBits, destAddress, destPort);
    }

    public Class<ClientMapping> getTargetClass() {
        return ClientMapping.class;
    }
}

