/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.configuration;

import java.sql.Driver;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfigurationChildBuilder;
import org.infinispan.persistence.jdbc.configuration.AbstractUnmanagedConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.ConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.PooledConnectionFactoryConfiguration;

public class PooledConnectionFactoryConfigurationBuilder<S extends AbstractJdbcStoreConfigurationBuilder<?, S>>
extends AbstractJdbcStoreConfigurationChildBuilder<S>
implements ConnectionFactoryConfigurationBuilder<PooledConnectionFactoryConfiguration>,
ConfigurationBuilderInfo {
    private final AttributeSet attributes = PooledConnectionFactoryConfiguration.attributeSet();

    public ElementDefinition getElementDefinition() {
        return PooledConnectionFactoryConfiguration.ELEMENT_DEFINITION;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    protected PooledConnectionFactoryConfigurationBuilder(AbstractJdbcStoreConfigurationBuilder<?, S> builder) {
        super(builder);
    }

    public PooledConnectionFactoryConfigurationBuilder<S> propertyFile(String propertyFile) {
        this.attributes.attribute(PooledConnectionFactoryConfiguration.PROPERTY_FILE).set((Object)propertyFile);
        return this;
    }

    public PooledConnectionFactoryConfigurationBuilder<S> connectionUrl(String connectionUrl) {
        this.attributes.attribute(AbstractUnmanagedConnectionFactoryConfiguration.CONNECTION_URL).set((Object)connectionUrl);
        return this;
    }

    public PooledConnectionFactoryConfigurationBuilder<S> driverClass(Class<? extends Driver> driverClass) {
        this.attributes.attribute(AbstractUnmanagedConnectionFactoryConfiguration.DRIVER_CLASS).set((Object)driverClass.getName());
        return this;
    }

    public PooledConnectionFactoryConfigurationBuilder<S> driverClass(String driverClass) {
        this.attributes.attribute(AbstractUnmanagedConnectionFactoryConfiguration.DRIVER_CLASS).set((Object)driverClass);
        return this;
    }

    public PooledConnectionFactoryConfigurationBuilder<S> username(String username) {
        this.attributes.attribute(AbstractUnmanagedConnectionFactoryConfiguration.USERNAME).set((Object)username);
        return this;
    }

    public PooledConnectionFactoryConfigurationBuilder<S> password(String password) {
        this.attributes.attribute(AbstractUnmanagedConnectionFactoryConfiguration.PASSWORD).set((Object)password);
        return this;
    }

    public void validate() {
        String propertyFile = (String)this.attributes.attribute(PooledConnectionFactoryConfiguration.PROPERTY_FILE).get();
        String connectionUrl = (String)this.attributes.attribute(AbstractUnmanagedConnectionFactoryConfiguration.CONNECTION_URL).get();
        if (propertyFile == null && connectionUrl == null) {
            throw new CacheConfigurationException("Missing connectionUrl parameter");
        }
    }

    public void validate(GlobalConfiguration globalConfig) {
    }

    public PooledConnectionFactoryConfiguration create() {
        return new PooledConnectionFactoryConfiguration(this.attributes.protect());
    }

    public PooledConnectionFactoryConfigurationBuilder<S> read(PooledConnectionFactoryConfiguration template) {
        this.attributes.read(template.attributes);
        return this;
    }
}

