/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.stomp;

import org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException;
import org.jboss.logging.Messages;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;

@MessageBundle(projectCode="AMQ")
public interface ActiveMQStompProtocolMessageBundle {
    public static final ActiveMQStompProtocolMessageBundle BUNDLE = (ActiveMQStompProtocolMessageBundle)Messages.getBundle(ActiveMQStompProtocolMessageBundle.class);

    @Message(id=339000, value="Stomp Connection TTL cannot be negative: {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException negativeConnectionTTL(Long var1);

    @Message(id=339001, value="Destination does not exist: {0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQStompException destinationNotExist(String var1);

    @Message(id=339002, value="Stomp versions not supported: {0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQStompException versionNotSupported(String var1);

    @Message(id=339003, value="Header host is null")
    public ActiveMQStompException nullHostHeader();

    @Message(id=339004, value="Cannot accept null as host")
    public String hostCannotBeNull();

    @Message(id=339005, value="Header host does not match server host")
    public ActiveMQStompException hostNotMatch();

    @Message(id=339006, value="host {0} does not match server host name", format=Message.Format.MESSAGE_FORMAT)
    public String hostNotMatchDetails(String var1);

    @Message(id=339007, value="Connection was destroyed.")
    public ActiveMQStompException connectionDestroyed();

    @Message(id=339008, value="Connection has not been established.")
    public ActiveMQStompException connectionNotEstablished();

    @Message(id=339009, value="Exception getting session")
    public ActiveMQStompException errorGetSession(@Cause Exception var1);

    @Message(id=339010, value="Connection is not valid.")
    public ActiveMQStompException invalidConnection();

    @Message(id=339011, value="Error sending message {0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQStompException errorSendMessage(org.apache.activemq.artemis.api.core.Message var1, @Cause Exception var2);

    @Message(id=339012, value="Error beginning a transaction {0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQStompException errorBeginTx(String var1, @Cause Exception var2);

    @Message(id=339013, value="Error committing {0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQStompException errorCommitTx(String var1, @Cause Exception var2);

    @Message(id=339014, value="Error aborting {0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQStompException errorAbortTx(String var1, @Cause Exception var2);

    @Message(id=339015, value="Client must set destination or id header to a SUBSCRIBE command")
    public ActiveMQStompException noDestination();

    @Message(id=339016, value="Error creating subscription {0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQStompException errorCreatingSubscription(String var1, @Cause Exception var2);

    @Message(id=339017, value="Error unsubscribing {0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQStompException errorUnsubscribing(String var1, @Cause Exception var2);

    @Message(id=339018, value="Error acknowledging message {0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQStompException errorAck(String var1, @Cause Exception var2);

    @Message(id=339019, value="Invalid char sequence: two consecutive CRs.")
    public ActiveMQStompException invalidTwoCRs();

    @Message(id=339020, value="Invalid char sequence: There is a CR not followed by an LF")
    public ActiveMQStompException badCRs();

    @Message(id=339021, value="Expect new line char but is {0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQStompException notValidNewLine(byte var1);

    @Message(id=339022, value="Expect new line char but is {0}", format=Message.Format.MESSAGE_FORMAT)
    public String unexpectedNewLine(byte var1);

    @Message(id=339023, value="Invalid STOMP frame: {0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQStompException invalidCommand(String var1);

    @Message(id=339024, value="Invalid STOMP frame: {0}", format=Message.Format.MESSAGE_FORMAT)
    public String invalidFrame(String var1);

    @Message(id=339025, value="failed to ack because no message with id: {0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQStompException failToAckMissingID(long var1);

    @Message(id=339026, value="subscription id {0} does not match {1}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQStompException subscriptionIDMismatch(String var1, String var2);

    @Message(id=339027, value="Cannot create a subscriber on the durable subscription if the client-id of the connection is not set")
    public IllegalStateException missingClientID();

    @Message(id=339028, value="Message header too big, increase minLargeMessageSize please.")
    public Exception headerTooBig();

    @Message(id=339029, value="Unsupported command: {0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQStompException unknownCommand(String var1);

    @Message(id=339030, value="transaction header is mandatory to COMMIT a transaction")
    public ActiveMQStompException needTxIDHeader();

    @Message(id=339031, value="Error handling send")
    public ActiveMQStompException errorHandleSend(@Cause Exception var1);

    @Message(id=339032, value="Need a transaction id to begin")
    public ActiveMQStompException beginTxNoID();

    @Message(id=339033, value="transaction header is mandatory to ABORT a transaction")
    public ActiveMQStompException abortTxNoID();

    @Message(id=339034, value="This method should not be called")
    public IllegalStateException invalidCall();

    @Message(id=339035, value="Must specify the subscription''s id or the destination you are unsubscribing from")
    public ActiveMQStompException needIDorDestination();

    @Message(id=339037, value="Must specify the subscription''s id")
    public ActiveMQStompException needSubscriptionID();

    @Message(id=339039, value="No id header in ACK/NACK frame.")
    public ActiveMQStompException noIDInAck();

    @Message(id=339040, value="Undefined escape sequence: {0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQStompException undefinedEscapeSequence(String var1);

    @Message(id=339041, value="Not allowed to specify {0} semantics on {1} address.", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQStompException illegalSemantics(String var1, String var2);
}

