/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.proton.transaction;

import java.util.LinkedList;
import java.util.Map;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.core.server.impl.RefsOperation;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerSenderContext;
import org.apache.activemq.artemis.protocol.amqp.proton.transaction.ProtonTransactionImpl;
import org.apache.qpid.proton.engine.Delivery;

public class ProtonTransactionRefsOperation
extends RefsOperation {
    public ProtonTransactionRefsOperation(Queue queue, AckReason reason, StorageManager storageManager) {
        super(queue, reason, storageManager);
    }

    public void rollbackRedelivery(Transaction txn, MessageReference ref, long timeBase, Map<QueueImpl, LinkedList<MessageReference>> queueMap) throws Exception {
        ProtonTransactionImpl tx = (ProtonTransactionImpl)txn;
        if (tx.getDeliveries().containsKey(ref)) {
            Delivery del = (Delivery)tx.getDeliveries().get(ref).getA();
            ServerConsumer consumer = (ServerConsumer)((ProtonServerSenderContext)tx.getDeliveries().get(ref).getB()).getBrokerConsumer();
            if (del.remotelySettled() || !tx.isDischarged()) {
                super.rollbackRedelivery((Transaction)tx, ref, timeBase, queueMap);
            } else {
                ref.incrementDeliveryCount();
                consumer.backToDelivering(ref);
                del.disposition(del.getLocalState() == null ? del.getDefaultDeliveryState() : del.getLocalState());
            }
        } else {
            super.rollbackRedelivery((Transaction)tx, ref, timeBase, queueMap);
        }
    }
}

