/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.impl;

import com.github.benmanes.caffeine.cache.Cache;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.commons.util.AbstractDelegatingConcurrentMap;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.PeekableTouchableMap;

public class PeekableTouchableCaffeineMap<K, V>
extends AbstractDelegatingConcurrentMap<K, InternalCacheEntry<K, V>>
implements PeekableTouchableMap<K, V> {
    private final Cache<K, InternalCacheEntry<K, V>> caffeineCache;
    private final ConcurrentMap<K, InternalCacheEntry<K, V>> map;

    public PeekableTouchableCaffeineMap(Cache<K, InternalCacheEntry<K, V>> cache) {
        this.caffeineCache = cache;
        this.map = cache.asMap();
    }

    protected ConcurrentMap<K, InternalCacheEntry<K, V>> delegate() {
        return this.map;
    }

    @Override
    public InternalCacheEntry<K, V> peek(Object key) {
        return (InternalCacheEntry)this.caffeineCache.policy().getIfPresentQuietly(key);
    }

    @Override
    public boolean touchKey(Object key, long currentTimeMillis) {
        InternalCacheEntry<K, V> ice = this.peek(key);
        if (ice != null) {
            ice.touch(currentTimeMillis);
            return true;
        }
        return false;
    }
}

