/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.security;

import javax.security.jacc.PolicyConfiguration;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ee.security.EarSecurityDeployer;
import org.jboss.as.ee.security.JaccService;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class JaccEarDeploymentProcessor
implements DeploymentUnitProcessor {
    private final String jaccCapabilityName;

    public JaccEarDeploymentProcessor(String jaccCapabilityName) {
        this.jaccCapabilityName = jaccCapabilityName;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        JaccService service;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EarSecurityDeployer deployer = null;
        if (DeploymentTypeMarker.isType(DeploymentType.EAR, deploymentUnit) && (service = (deployer = new EarSecurityDeployer()).deploy(deploymentUnit)) != null) {
            ServiceName jaccServiceName = deploymentUnit.getServiceName().append(JaccService.SERVICE_NAME);
            ServiceTarget serviceTarget = phaseContext.getServiceTarget();
            ServiceBuilder builder = serviceTarget.addService(jaccServiceName, service);
            if (deploymentUnit.getParent() != null) {
                DeploymentUnit parentDU = deploymentUnit.getParent();
                builder.addDependency(parentDU.getServiceName().append(JaccService.SERVICE_NAME), PolicyConfiguration.class, service.getParentPolicyInjector());
            }
            CapabilityServiceSupport capabilitySupport = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
            builder.addDependencies(new ServiceName[]{capabilitySupport.getCapabilityServiceName(this.jaccCapabilityName)});
            builder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
    }

    public void undeploy(DeploymentUnit context) {
        EarSecurityDeployer deployer = null;
        if (DeploymentTypeMarker.isType(DeploymentType.EAR, context)) {
            deployer = new EarSecurityDeployer();
            deployer.undeploy(context);
        }
    }
}

