/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.concurrent.ThreadLocalRandom;
import org.infinispan.commons.util.Util;
import org.infinispan.util.ExponentialBackOff;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ExponentialBackOffImpl
implements ExponentialBackOff {
    private static final Log log = LogFactory.getLog(ExponentialBackOffImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final double MULTIPLIER = 2.0;
    private static final int INITIAL_INTERVAL_MILLIS = 500;
    private static final int MAX_INTERVAL_MILLIS = 300000;
    private static final double RANDOMIZATION_FACTOR = 0.5;
    private int currentIntervalMillis = 500;

    long nextBackOffMillis() {
        if (this.currentIntervalMillis >= 300000) {
            if (trace) {
                log.tracef("Next backoff time %s ms", 300000);
            }
            return 300000L;
        }
        int randomIntervalMillis = this.getRandomValueFromInterval();
        this.incrementCurrentInterval();
        if (trace) {
            log.tracef("Next backoff time %s ms", randomIntervalMillis);
        }
        return Math.min(randomIntervalMillis, 300000);
    }

    @Override
    public void backoffSleep() throws InterruptedException {
        long sleepTime = this.nextBackOffMillis();
        if (trace) {
            log.tracef("backing-off for %s.", Util.prettyPrintTime((long)sleepTime));
        }
        Thread.sleep(sleepTime);
    }

    @Override
    public void reset() {
        this.currentIntervalMillis = 500;
    }

    private void incrementCurrentInterval() {
        this.currentIntervalMillis = this.currentIntervalMillis >= 300000 ? 300000 : (int)((double)this.currentIntervalMillis * 2.0);
    }

    private int getRandomValueFromInterval() {
        double delta = 0.5 * (double)this.currentIntervalMillis;
        return (int)(delta + ThreadLocalRandom.current().nextDouble() * (double)this.currentIntervalMillis);
    }
}

