/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jgroups.Address;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.protocols.Discovery;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Responses;

public class MULTI_PING
extends Discovery {
    protected final List<Discovery> discovery_protocols = new ArrayList<Discovery>();

    @ManagedAttribute(description="List of discovery protocols")
    public String getDiscoveryProtocols() {
        return this.discovery_protocols.stream().map(p -> p.getClass().getSimpleName()).collect(Collectors.joining(", "));
    }

    @Override
    public boolean isDynamic() {
        return this.discovery_protocols.stream().anyMatch(Discovery::isDynamic);
    }

    @Override
    public void init() throws Exception {
        Protocol p;
        super.init();
        for (p = this.up_prot; p != null; p = p.getUpProtocol()) {
            if (!(p instanceof Discovery)) continue;
            throw new IllegalStateException(String.format("found %s above %s: this is invalid; all discovery protocols must be placed below %s", p.getClass().getSimpleName(), this.getClass().getSimpleName(), this.getClass().getSimpleName()));
        }
        for (p = this.down_prot; p != null; p = p.getDownProtocol()) {
            if (!(p instanceof Discovery)) continue;
            this.discovery_protocols.add((Discovery)p);
        }
    }

    @Override
    public void weedOutCompletedDiscoveryResponses() {
        super.weedOutCompletedDiscoveryResponses();
        for (Discovery p : this.discovery_protocols) {
            p.weedOutCompletedDiscoveryResponses();
        }
    }

    @Override
    protected void findMembers(List<Address> members, boolean initial_discovery, Responses responses) {
    }

    @Override
    protected void invokeFindMembers(List<Address> members, boolean initial_discovery, Responses rsps, boolean async) {
        this.findMembers(members, initial_discovery, rsps, async);
    }

    protected void findMembers(List<Address> members, boolean initial_discovery, Responses rsps, boolean async) {
        for (Discovery discovery_protocol : this.discovery_protocols) {
            discovery_protocol.addResponse(rsps);
            if (this.discovery_rsp_callback != null) {
                discovery_protocol.discovery_rsp_callback = this.discovery_rsp_callback;
            }
            if (async || this.async_discovery) {
                this.timer.execute(() -> discovery_protocol.findMembers(members, initial_discovery, rsps));
                continue;
            }
            discovery_protocol.findMembers(members, initial_discovery, rsps);
        }
    }
}

