/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.wst;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.parsers.ParserNamespaceSupport;
import org.picketlink.common.util.StaxParserUtil;
import org.picketlink.identity.federation.core.parsers.ParserController;
import org.picketlink.identity.federation.core.parsers.util.SAMLParserUtil;
import org.picketlink.identity.federation.core.parsers.wst.WSTCancelTargetParser;
import org.picketlink.identity.federation.core.parsers.wst.WSTRenewTargetParser;
import org.picketlink.identity.federation.core.parsers.wst.WSTValidateTargetParser;
import org.picketlink.identity.federation.core.parsers.wst.WSTrustOnBehalfOfParser;
import org.picketlink.identity.federation.core.wstrust.WSTrustUtil;
import org.picketlink.identity.federation.core.wstrust.wrappers.Lifetime;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityToken;
import org.picketlink.identity.federation.ws.addressing.AttributedURIType;
import org.picketlink.identity.federation.ws.addressing.EndpointReferenceType;
import org.picketlink.identity.federation.ws.policy.AppliesTo;
import org.picketlink.identity.federation.ws.trust.BinarySecretType;
import org.picketlink.identity.federation.ws.trust.CancelTargetType;
import org.picketlink.identity.federation.ws.trust.EntropyType;
import org.picketlink.identity.federation.ws.trust.LifetimeType;
import org.picketlink.identity.federation.ws.trust.OnBehalfOfType;
import org.picketlink.identity.federation.ws.trust.RenewTargetType;
import org.picketlink.identity.federation.ws.trust.SimpleAnyType;
import org.picketlink.identity.federation.ws.trust.UseKeyType;
import org.picketlink.identity.federation.ws.trust.ValidateTargetType;
import org.picketlink.identity.federation.ws.wss.utility.AttributedDateTime;
import org.picketlink.identity.xmlsec.w3.xmldsig.KeyInfoType;
import org.w3c.dom.Element;

public class WSTRequestSecurityTokenParser
implements ParserNamespaceSupport {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    public static final String X509CERTIFICATE = "X509Certificate";
    public static final String KEYVALUE = "KeyValue";

    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        XMLEvent xmlEvent;
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        RequestSecurityToken requestToken = new RequestSecurityToken();
        QName contextQName = new QName("", "Context");
        Attribute contextAttribute = startElement.getAttributeByName(contextQName);
        if (contextAttribute != null) {
            String contextValue = StaxParserUtil.getAttributeValue((Attribute)contextAttribute);
            requestToken.setContext(contextValue);
        }
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader)) != null) {
            if (xmlEvent instanceof EndElement) {
                xmlEvent = StaxParserUtil.getNextEvent((XMLEventReader)xmlEventReader);
                EndElement endElement = (EndElement)xmlEvent;
                String endElementTag = StaxParserUtil.getEndElementName((EndElement)endElement);
                if (endElementTag.equals("RequestSecurityToken")) break;
                if (endElementTag.equals("SecondaryParameters") || endElementTag.equals("UseKey")) continue;
                throw logger.parserUnknownEndElement(endElementTag);
            }
            try {
                EndElement validateTargetEndElement;
                SimpleAnyType validateTarget;
                Object wstValidateTargetParser;
                String value;
                StartElement subEvent = StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader);
                if (subEvent == null) break;
                String tag = StaxParserUtil.getStartElementName((StartElement)subEvent);
                if (tag.equals("RequestType")) {
                    subEvent = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                    if (!StaxParserUtil.hasTextAhead((XMLEventReader)xmlEventReader)) {
                        throw new ParsingException("PL00071: Parser: Expected text value:request type");
                    }
                    value = StaxParserUtil.getElementText((XMLEventReader)xmlEventReader);
                    requestToken.setRequestType(new URI(value));
                    continue;
                }
                if (tag.equals("TokenType")) {
                    subEvent = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                    if (!StaxParserUtil.hasTextAhead((XMLEventReader)xmlEventReader)) {
                        throw new ParsingException("PL00071: Parser: Expected text value:token type");
                    }
                    value = StaxParserUtil.getElementText((XMLEventReader)xmlEventReader);
                    requestToken.setTokenType(new URI(value));
                    continue;
                }
                if (tag.equals("Lifetime")) {
                    subEvent = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                    StaxParserUtil.validate((StartElement)subEvent, (String)"Lifetime");
                    LifetimeType lifeTime = new LifetimeType();
                    subEvent = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                    String subTag = StaxParserUtil.getStartElementName((StartElement)subEvent);
                    if (subTag.equals("Created")) {
                        AttributedDateTime created = new AttributedDateTime();
                        created.setValue(StaxParserUtil.getElementText((XMLEventReader)xmlEventReader));
                        lifeTime.setCreated(created);
                    }
                    if (!(subTag = StaxParserUtil.getStartElementName((StartElement)(subEvent = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader)))).equals("Expires")) {
                        throw new RuntimeException("PL00062: Parser : Unknown tag:" + subTag);
                    }
                    AttributedDateTime expires = new AttributedDateTime();
                    expires.setValue(StaxParserUtil.getElementText((XMLEventReader)xmlEventReader));
                    lifeTime.setExpires(expires);
                    requestToken.setLifetime(new Lifetime(lifeTime));
                    EndElement lifeTimeElement = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                    StaxParserUtil.validate((EndElement)lifeTimeElement, (String)"Lifetime");
                    continue;
                }
                if (tag.equals("CancelTarget")) {
                    subEvent = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                    StaxParserUtil.validate((StartElement)subEvent, (String)"CancelTarget");
                    WSTCancelTargetParser wstCancelTargetParser = new WSTCancelTargetParser();
                    CancelTargetType cancelTarget = (CancelTargetType)wstCancelTargetParser.parse(xmlEventReader);
                    requestToken.setCancelTarget(cancelTarget);
                    EndElement cancelTargetEndElement = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                    StaxParserUtil.validate((EndElement)cancelTargetEndElement, (String)"CancelTarget");
                    continue;
                }
                if (tag.equals("ValidateTarget")) {
                    subEvent = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                    wstValidateTargetParser = new WSTValidateTargetParser();
                    validateTarget = (ValidateTargetType)((WSTValidateTargetParser)wstValidateTargetParser).parse(xmlEventReader);
                    requestToken.setValidateTarget((ValidateTargetType)validateTarget);
                    validateTargetEndElement = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                    StaxParserUtil.validate((EndElement)validateTargetEndElement, (String)"ValidateTarget");
                    continue;
                }
                if (tag.equals("RenewTarget")) {
                    subEvent = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                    wstValidateTargetParser = new WSTRenewTargetParser();
                    validateTarget = (RenewTargetType)((WSTRenewTargetParser)wstValidateTargetParser).parse(xmlEventReader);
                    requestToken.setRenewTarget((RenewTargetType)validateTarget);
                    validateTargetEndElement = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                    StaxParserUtil.validate((EndElement)validateTargetEndElement, (String)"RenewTarget");
                    continue;
                }
                if (tag.equals("OnBehalfOf")) {
                    subEvent = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                    WSTrustOnBehalfOfParser wstOnBehalfOfParser = new WSTrustOnBehalfOfParser();
                    OnBehalfOfType onBehalfOf = (OnBehalfOfType)wstOnBehalfOfParser.parse(xmlEventReader);
                    requestToken.setOnBehalfOf(onBehalfOf);
                    EndElement onBehalfOfEndElement = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                    StaxParserUtil.validate((EndElement)onBehalfOfEndElement, (String)"OnBehalfOf");
                    continue;
                }
                if (tag.equals("KeyType")) {
                    subEvent = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                    if (!StaxParserUtil.hasTextAhead((XMLEventReader)xmlEventReader)) {
                        throw new ParsingException("PL00071: Parser: Expected text value:key type");
                    }
                    String keyType = StaxParserUtil.getElementText((XMLEventReader)xmlEventReader);
                    try {
                        URI keyTypeURI = new URI(keyType);
                        requestToken.setKeyType(keyTypeURI);
                        continue;
                    }
                    catch (URISyntaxException e) {
                        throw new ParsingException((Throwable)e);
                    }
                }
                if (tag.equals("KeySize")) {
                    subEvent = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                    if (!StaxParserUtil.hasTextAhead((XMLEventReader)xmlEventReader)) {
                        throw new ParsingException("PL00071: Parser: Expected text value:key size");
                    }
                    String keySize = StaxParserUtil.getElementText((XMLEventReader)xmlEventReader);
                    try {
                        requestToken.setKeySize(Long.parseLong(keySize));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new ParsingException((Throwable)e);
                    }
                }
                if (tag.equals("Entropy")) {
                    subEvent = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                    EntropyType entropy = new EntropyType();
                    subEvent = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                    if (StaxParserUtil.matches((StartElement)subEvent, (String)"BinarySecret")) {
                        BinarySecretType binarySecret = new BinarySecretType();
                        Attribute typeAttribute = subEvent.getAttributeByName(new QName("", "Type"));
                        binarySecret.setType(StaxParserUtil.getAttributeValue((Attribute)typeAttribute));
                        if (!StaxParserUtil.hasTextAhead((XMLEventReader)xmlEventReader)) {
                            throw new ParsingException("PL00071: Parser: Expected text value:binary secret value");
                        }
                        binarySecret.setValue(StaxParserUtil.getElementText((XMLEventReader)xmlEventReader).getBytes());
                        entropy.addAny(binarySecret);
                    }
                    requestToken.setEntropy(entropy);
                    EndElement endElement = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                    StaxParserUtil.validate((EndElement)endElement, (String)"Entropy");
                    continue;
                }
                if (tag.equals("Issuer")) {
                    subEvent = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                    StaxParserUtil.validate((StartElement)subEvent, (String)"Issuer");
                    subEvent = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                    StaxParserUtil.validate((StartElement)subEvent, (String)"Address");
                    String addressValue = StaxParserUtil.getElementText((XMLEventReader)xmlEventReader);
                    EndpointReferenceType endpointRef = new EndpointReferenceType();
                    AttributedURIType attrURI = new AttributedURIType();
                    attrURI.setValue(addressValue);
                    endpointRef.setAddress(new AttributedURIType());
                    requestToken.setIssuer(endpointRef);
                    EndElement endElement = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                    StaxParserUtil.validate((EndElement)endElement, (String)"Issuer");
                    continue;
                }
                if (tag.equals("SecondaryParameters")) {
                    subEvent = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                    continue;
                }
                if (tag.equals("UseKey")) {
                    Element domElement;
                    subEvent = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                    UseKeyType useKeyType = new UseKeyType();
                    StaxParserUtil.validate((StartElement)subEvent, (String)"UseKey");
                    subEvent = StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader);
                    if (StaxParserUtil.matches((StartElement)subEvent, (String)X509CERTIFICATE)) {
                        domElement = StaxParserUtil.getDOMElement((XMLEventReader)xmlEventReader);
                        useKeyType.add(domElement);
                        requestToken.setUseKey(useKeyType);
                        continue;
                    }
                    if (StaxParserUtil.matches((StartElement)subEvent, (String)KEYVALUE)) {
                        domElement = StaxParserUtil.getDOMElement((XMLEventReader)xmlEventReader);
                        useKeyType.add(domElement);
                        requestToken.setUseKey(useKeyType);
                        EndElement endElement = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                        StaxParserUtil.validate((EndElement)endElement, (String)"UseKey");
                        continue;
                    }
                    if (StaxParserUtil.matches((StartElement)subEvent, (String)"KeyInfo")) {
                        KeyInfoType keyInfo = SAMLParserUtil.parseKeyInfo(xmlEventReader);
                        useKeyType = requestToken.getUseKey();
                        if (useKeyType == null) {
                            useKeyType = new UseKeyType();
                        }
                        useKeyType.add(keyInfo);
                        requestToken.setUseKey(useKeyType);
                        continue;
                    }
                    throw new RuntimeException("PL00069: Parser: Type not supported:" + StaxParserUtil.getStartElementName((StartElement)subEvent));
                }
                if (tag.equals("ComputedKeyAlgorithm")) {
                    subEvent = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                    if (!StaxParserUtil.hasTextAhead((XMLEventReader)xmlEventReader)) {
                        throw new ParsingException("PL00071: Parser: Expected text value:ComputedKeyAlgorithm");
                    }
                    String computedKeyAlgo = StaxParserUtil.getElementText((XMLEventReader)xmlEventReader);
                    requestToken.setComputedKeyAlgorithm(URI.create(computedKeyAlgo));
                    continue;
                }
                if (tag.equals("Renewing")) {
                    requestToken.setRenewing(WSTrustUtil.parseRenewingType(xmlEventReader));
                    continue;
                }
                QName qname = subEvent.getName();
                logger.trace("Looking for parser for element: " + qname);
                ParserNamespaceSupport parser = ParserController.get(qname);
                if (parser == null) {
                    throw logger.parserUnknownTag(qname.getLocalPart(), subEvent.getLocation());
                }
                Object parsedObject = parser.parse(xmlEventReader);
                if (!(parsedObject instanceof AppliesTo)) continue;
                requestToken.setAppliesTo((AppliesTo)parsedObject);
            }
            catch (URISyntaxException e) {
                throw new ParsingException((Throwable)e);
            }
        }
        return requestToken;
    }

    public boolean supports(QName qname) {
        String nsURI = qname.getNamespaceURI();
        String localPart = qname.getLocalPart();
        return "http://docs.oasis-open.org/ws-sx/ws-trust/200512".equals(nsURI) && "RequestSecurityToken".equals(localPart);
    }
}

