/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.asn1;

import org.wildfly.common.array.Arrays2;
import org.wildfly.security.asn1.ASN1Decoder;
import org.wildfly.security.asn1.ASN1Exception;
import org.wildfly.security.asn1.ElytronMessages;

public class ASN1 {
    public static final int BOOLEAN_TYPE = 1;
    public static final int INTEGER_TYPE = 2;
    public static final int BIT_STRING_TYPE = 3;
    public static final int OCTET_STRING_TYPE = 4;
    public static final int NULL_TYPE = 5;
    public static final int OBJECT_IDENTIFIER_TYPE = 6;
    public static final int UTF8_STRING_TYPE = 12;
    public static final int PRINTABLE_STRING_TYPE = 19;
    public static final int IA5_STRING_TYPE = 22;
    public static final int GENERALIZED_TIME_TYPE = 24;
    public static final int UNIVERSAL_STRING_TYPE = 28;
    public static final int BMP_STRING_TYPE = 30;
    public static final int SEQUENCE_TYPE = 48;
    public static final int SET_TYPE = 49;
    public static final int CONSTRUCTED_MASK = 32;
    public static final int APPLICATION_SPECIFIC_MASK = 64;
    public static final int CONTEXT_SPECIFIC_MASK = 128;
    public static final int CLASS_MASK = 192;
    public static final int TAG_NUMBER_MASK = 31;
    public static final String OID_SHA1_WITH_DSA = "1.2.840.10040.4.3";
    public static final String OID_SHA256_WITH_DSA = "2.16.840.1.101.3.4.3.2";
    public static final String OID_SHA1_WITH_ECDSA = "1.2.840.10045.4.1";
    public static final String OID_SHA224_WITH_ECDSA = "1.2.840.10045.4.3.1";
    public static final String OID_SHA256_WITH_ECDSA = "1.2.840.10045.4.3.2";
    public static final String OID_SHA384_WITH_ECDSA = "1.2.840.10045.4.3.3";
    public static final String OID_SHA512_WITH_ECDSA = "1.2.840.10045.4.3.4";
    public static final String OID_MD2_WITH_RSA = "1.2.840.113549.1.1.2";
    public static final String OID_MD4_WITH_RSA = "1.2.840.113549.1.1.3";
    public static final String OID_MD5_WITH_RSA = "1.2.840.113549.1.1.4";
    public static final String OID_SHA1_WITH_RSA = "1.2.840.113549.1.1.5";
    public static final String OID_SHA256_WITH_RSA = "1.2.840.113549.1.1.11";
    public static final String OID_SHA384_WITH_RSA = "1.2.840.113549.1.1.12";
    public static final String OID_SHA512_WITH_RSA = "1.2.840.113549.1.1.13";
    public static final String OID_EXTENSION_REQUEST = "1.2.840.113549.1.9.14";
    public static final String OID_MD2 = "1.2.840.113549.2.2";
    public static final String OID_MD5 = "1.2.840.113549.2.5";
    public static final String OID_SHA1 = "1.3.14.3.2.26";
    public static final String OID_RSA = "1.2.840.113549.1.1.1";
    public static final String OID_DSA = "1.2.840.10040.4.1";
    public static final String OID_EC = "1.2.840.10045.2.1";

    public static String formatAsn1(ASN1Decoder decoder) {
        StringBuilder builder = new StringBuilder();
        ASN1.formatAsn1(decoder, builder);
        return builder.toString();
    }

    public static void formatAsn1(ASN1Decoder decoder, StringBuilder builder) {
        block14: while (decoder.hasNextElement()) {
            int type = decoder.peekType();
            switch (type) {
                case 2: {
                    builder.append("[int:").append(decoder.decodeInteger()).append("]");
                    continue block14;
                }
                case 3: {
                    builder.append("[bits:").append(decoder.decodeBitStringAsString()).append(']');
                    continue block14;
                }
                case 4: {
                    builder.append("[octets:").append(Arrays2.toString(decoder.decodeOctetString())).append(']');
                    continue block14;
                }
                case 5: {
                    builder.append("[null]");
                    decoder.decodeNull();
                    continue block14;
                }
                case 6: {
                    builder.append("[oid:").append(decoder.decodeObjectIdentifier()).append(']');
                    continue block14;
                }
                case 22: {
                    builder.append("[ia5:").append(decoder.decodeIA5String()).append(']');
                    continue block14;
                }
                case 48: {
                    builder.append("[sequence:");
                    decoder.startSequence();
                    ASN1.formatAsn1(decoder, builder);
                    decoder.endSequence();
                    builder.append(']');
                    continue block14;
                }
                case 49: {
                    builder.append("[set:");
                    decoder.startSet();
                    ASN1.formatAsn1(decoder, builder);
                    decoder.endSet();
                    builder.append(']');
                    continue block14;
                }
                case 19: {
                    builder.append("[printable:").append(decoder.decodePrintableString()).append(']');
                    continue block14;
                }
                case 28: {
                    builder.append("[universal:").append(decoder.decodeUniversalString()).append(']');
                    continue block14;
                }
                case 12: {
                    builder.append("[utf8:").append(decoder.decodeUtf8String()).append(']');
                    continue block14;
                }
                case 30: {
                    builder.append("[bmp:").append(decoder.decodeBMPString()).append(']');
                    continue block14;
                }
            }
            throw ElytronMessages.log.asnUnknownTagType(type);
        }
    }

    public static String keyAlgorithmFromOid(String oid) {
        switch (oid) {
            case "1.2.840.113549.1.1.1": {
                return "RSA";
            }
            case "1.2.840.10040.4.1": {
                return "DSA";
            }
            case "1.2.840.10045.2.1": {
                return "EC";
            }
        }
        return null;
    }

    public static String oidFromSignatureAlgorithm(String algorithmName) {
        switch (algorithmName) {
            case "NONEwithRSA": {
                return null;
            }
            case "MD2withRSA": {
                return OID_MD2_WITH_RSA;
            }
            case "MD5withRSA": {
                return OID_MD5_WITH_RSA;
            }
            case "SHA1withRSA": {
                return OID_SHA1_WITH_RSA;
            }
            case "SHA256withRSA": {
                return OID_SHA256_WITH_RSA;
            }
            case "SHA384withRSA": {
                return OID_SHA384_WITH_RSA;
            }
            case "SHA512withRSA": {
                return OID_SHA512_WITH_RSA;
            }
            case "NONEwithDSA": {
                return null;
            }
            case "SHA1withDSA": {
                return OID_SHA1_WITH_DSA;
            }
            case "SHA256withDSA": {
                return OID_SHA256_WITH_DSA;
            }
            case "NONEwithECDSA": {
                return null;
            }
            case "ECDSA": 
            case "SHA1withECDSA": {
                return OID_SHA1_WITH_ECDSA;
            }
            case "SHA256withECDSA": {
                return OID_SHA256_WITH_ECDSA;
            }
            case "SHA384withECDSA": {
                return OID_SHA384_WITH_ECDSA;
            }
            case "SHA512withECDSA": {
                return OID_SHA512_WITH_ECDSA;
            }
        }
        return null;
    }

    public static String signatureAlgorithmFromOid(String oid) {
        switch (oid) {
            case "1.2.840.113549.1.1.2": {
                return "MD2withRSA";
            }
            case "1.2.840.113549.1.1.4": {
                return "MD5withRSA";
            }
            case "1.2.840.113549.1.1.5": {
                return "SHA1withRSA";
            }
            case "1.2.840.113549.1.1.11": {
                return "SHA256withRSA";
            }
            case "1.2.840.113549.1.1.12": {
                return "SHA384withRSA";
            }
            case "1.2.840.113549.1.1.13": {
                return "SHA512withRSA";
            }
            case "1.2.840.10040.4.3": {
                return "SHA1withDSA";
            }
            case "1.2.840.10045.4.1": {
                return "SHA1withECDSA";
            }
            case "1.2.840.10045.4.3.2": {
                return "SHA256withECDSA";
            }
            case "1.2.840.10045.4.3.3": {
                return "SHA384withECDSA";
            }
            case "1.2.840.10045.4.3.4": {
                return "SHA512withECDSA";
            }
        }
        return null;
    }

    public static void validatePrintableByte(int b) throws ASN1Exception {
        switch (b) {
            case 32: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 58: 
            case 61: 
            case 63: {
                return;
            }
        }
        if (65 <= b && b <= 90 || 97 <= b && b <= 122 || 48 <= b && b <= 57) {
            return;
        }
        throw ElytronMessages.log.asnUnexpectedCharacterByteForPrintableString();
    }
}

