/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.audit;

import java.security.Permission;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.function.Supplier;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.event.SecurityAuthenticationFailedEvent;
import org.wildfly.security.auth.server.event.SecurityDefiniteOutcomeEvent;
import org.wildfly.security.auth.server.event.SecurityEvent;
import org.wildfly.security.auth.server.event.SecurityEventVisitor;
import org.wildfly.security.auth.server.event.SecurityPermissionCheckEvent;
import org.wildfly.security.auth.server.event.SecurityRealmUnavailableEvent;
import org.wildfly.security.auth.server.event.SyslogAuditEvent;

public class SimpleSecurityEventFormatter
extends SecurityEventVisitor<Void, String> {
    private final Supplier<DateTimeFormatter> dateFormatSupplier;

    SimpleSecurityEventFormatter(Builder builder) {
        this.dateFormatSupplier = builder.dateTimeFormatterSupplier;
    }

    @Override
    public String handleUnknownEvent(SecurityEvent event, Void param) {
        Assert.checkNotNullParam("event", event);
        StringBuilder stringBuilder = new StringBuilder("{");
        this.handleUnknownEvent(event, stringBuilder);
        return stringBuilder.append('}').toString();
    }

    @Override
    private void handleUnknownEvent(SecurityEvent event, StringBuilder stringBuilder) {
        DateTimeFormatter dateFormat = this.dateFormatSupplier.get();
        stringBuilder.append("event=").append(event.getClass().getSimpleName());
        stringBuilder.append(",event-time=").append(dateFormat.format(event.getInstant()));
        SecurityIdentity securityIdentity = event.getSecurityIdentity();
        stringBuilder.append(",security-identity=[name=").append(securityIdentity.getPrincipal().getName());
        stringBuilder.append(",creation-time=").append(dateFormat.format(securityIdentity.getCreationTime())).append(']');
    }

    @Override
    public String handleDefiniteOutcomeEvent(SecurityDefiniteOutcomeEvent event, Void param) {
        Assert.checkNotNullParam("event", event);
        StringBuilder stringBuilder = new StringBuilder("{");
        this.handleDefiniteOutcomeEvent(event, stringBuilder);
        return stringBuilder.append('}').toString();
    }

    @Override
    private void handleDefiniteOutcomeEvent(SecurityDefiniteOutcomeEvent event, StringBuilder stringBuilder) {
        this.handleUnknownEvent((SecurityEvent)event, stringBuilder);
        stringBuilder.append(",success=").append(event.isSuccessful());
    }

    @Override
    public String handleAuthenticationFailedEvent(SecurityAuthenticationFailedEvent event, Void param) {
        Assert.checkNotNullParam("event", event);
        StringBuilder stringBuilder = new StringBuilder("{");
        this.handleAuthenticationFailedEvent(event, stringBuilder);
        return stringBuilder.append('}').toString();
    }

    @Override
    private void handleAuthenticationFailedEvent(SecurityAuthenticationFailedEvent event, StringBuilder stringBuilder) {
        this.handleDefiniteOutcomeEvent((SecurityDefiniteOutcomeEvent)event, stringBuilder);
        stringBuilder.append(",principal=").append(event.getPrincipal() != null ? event.getPrincipal().toString() : null);
    }

    @Override
    public String handlePermissionCheckEvent(SecurityPermissionCheckEvent event, Void param) {
        Assert.checkNotNullParam("event", event);
        StringBuilder stringBuilder = new StringBuilder("{");
        this.handlePermissionCheckEvent(event, stringBuilder);
        return stringBuilder.append('}').toString();
    }

    @Override
    private void handlePermissionCheckEvent(SecurityPermissionCheckEvent event, StringBuilder stringBuilder) {
        this.handleDefiniteOutcomeEvent((SecurityDefiniteOutcomeEvent)event, stringBuilder);
        Permission permission = event.getPermission();
        stringBuilder.append(",permission=[type=").append(permission.getClass().getName());
        stringBuilder.append(",actions=").append(permission.getActions());
        stringBuilder.append(",name=").append(permission.getName()).append(']');
    }

    @Override
    public String handleSyslogAuditEvent(SyslogAuditEvent event, Void param) {
        Assert.checkNotNullParam("event", event);
        StringBuilder stringBuilder = new StringBuilder("{");
        this.handleSyslogAuditEvent(event, stringBuilder);
        return stringBuilder.append('}').toString();
    }

    @Override
    private void handleSyslogAuditEvent(SyslogAuditEvent event, StringBuilder stringBuilder) {
        this.handleUnknownEvent((SecurityEvent)event, stringBuilder);
        stringBuilder.append(",syslog-format").append(event.getFormat().toString());
    }

    @Override
    public String handleRealmUnavailableEvent(SecurityRealmUnavailableEvent event, Void param) {
        Assert.checkNotNullParam("event", event);
        StringBuilder stringBuilder = new StringBuilder("{");
        this.handleRealmUnavailableEvent(event, stringBuilder);
        return stringBuilder.append('}').toString();
    }

    @Override
    private void handleRealmUnavailableEvent(SecurityRealmUnavailableEvent event, StringBuilder stringBuilder) {
        this.handleUnknownEvent((SecurityEvent)event, stringBuilder);
        stringBuilder.append(",realm-name=").append(event.getRealmName());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Supplier<DateTimeFormatter> dateTimeFormatterSupplier = () -> DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).withZone(ZoneId.systemDefault());

        Builder() {
        }

        public Builder setDateTimeFormatterSupplier(Supplier<DateTimeFormatter> dateTimeFormatterSupplier) {
            this.dateTimeFormatterSupplier = Assert.checkNotNullParam("dateTimeFormatterSupplier", dateTimeFormatterSupplier);
            return this;
        }

        public SecurityEventVisitor<Void, String> build() {
            return new SimpleSecurityEventFormatter(this);
        }
    }
}

