/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics;

import io.smallrye.metrics.MetricRegistries;
import io.smallrye.metrics.exporters.Exporter;
import io.smallrye.metrics.exporters.JsonExporter;
import io.smallrye.metrics.exporters.JsonMetadataExporter;
import io.smallrye.metrics.exporters.OpenMetricsExporter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.metrics.MetricRegistry;

@ApplicationScoped
public class MetricsRequestHandler {
    private static final Map<String, String> corsHeaders = new HashMap<String, String>();
    private static final String TEXT_PLAIN = "text/plain";
    private static final String APPLICATION_JSON = "application/json";
    private static final String STAR_STAR = "*/*";

    public void handleRequest(String requestPath, String method, Stream<String> acceptHeaders, Responder responder) throws IOException {
        this.handleRequest(requestPath, "/metrics", method, acceptHeaders, responder);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void handleRequest(String requestPath, String contextRoot, String method, Stream<String> acceptHeaders, Responder responder) throws IOException {
        StringBuilder sb;
        Exporter exporter = this.obtainExporter(method, acceptHeaders, responder);
        if (exporter == null) {
            return;
        }
        if (!requestPath.startsWith(contextRoot)) {
            responder.respondWith(500, "The expected context root of metrics is " + contextRoot + ", but a request with a different path was routed to MetricsRequestHandler", Collections.emptyMap());
            return;
        }
        String scopePath = requestPath.substring(contextRoot.length());
        if (scopePath.startsWith("/")) {
            scopePath = scopePath.substring(1);
        }
        if (scopePath.endsWith("/")) {
            scopePath = scopePath.substring(0, scopePath.length() - 1);
        }
        if (scopePath.isEmpty()) {
            sb = exporter.exportAllScopes();
        } else if (scopePath.contains("/")) {
            String metricName = scopePath.substring(scopePath.indexOf(47) + 1);
            MetricRegistry.Type scope = this.getScopeFromPath(scopePath.substring(0, scopePath.indexOf(47)));
            if (scope == null) {
                responder.respondWith(404, "Scope " + scopePath + " not found", Collections.emptyMap());
                return;
            }
            MetricRegistry registry = MetricRegistries.get(scope);
            Map metricValuesMap = registry.getMetrics();
            if (!metricValuesMap.keySet().stream().anyMatch(id -> id.getName().equals(metricName))) {
                responder.respondWith(404, "Metric " + scopePath + " not found", Collections.emptyMap());
                return;
            }
            sb = exporter.exportMetricsByName(scope, metricName);
        } else {
            MetricRegistry.Type scope = this.getScopeFromPath(scopePath);
            if (scope == null) {
                responder.respondWith(404, "Scope " + scopePath + " not found", Collections.emptyMap());
                return;
            }
            MetricRegistry reg = MetricRegistries.get(scope);
            if (reg.getMetadata().size() == 0) {
                responder.respondWith(204, "No data in scope " + scopePath, Collections.emptyMap());
                return;
            }
            sb = exporter.exportOneScope(scope);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", exporter.getContentType());
        headers.put("Access-Control-Max-Age", "1209600");
        headers.putAll(corsHeaders);
        responder.respondWith(200, sb.toString(), headers);
    }

    private MetricRegistry.Type getScopeFromPath(String scopePath) throws IOException {
        MetricRegistry.Type scope;
        try {
            scope = MetricRegistry.Type.valueOf((String)scopePath.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
        return scope;
    }

    private Exporter obtainExporter(String method, Stream<String> acceptHeaders, Responder responder) throws IOException {
        if (!method.equals("GET") && !method.equals("OPTIONS")) {
            responder.respondWith(405, "Only GET and OPTIONS methods are accepted.", Collections.emptyMap());
            return null;
        }
        if (acceptHeaders == null) {
            if (method.equals("GET")) {
                return new OpenMetricsExporter();
            }
            responder.respondWith(405, "OPTIONS method is only allowed with application/json media type.", Collections.emptyMap());
            return null;
        }
        Optional<String> mt = this.getBestMatchingMediaType(acceptHeaders);
        if (mt.isPresent()) {
            String mediaType = mt.get();
            if (mediaType.startsWith(APPLICATION_JSON)) {
                if (method.equals("GET")) {
                    return new JsonExporter();
                }
                return new JsonMetadataExporter();
            }
            if (method.equals("GET")) {
                return new OpenMetricsExporter();
            }
            responder.respondWith(406, "OPTIONS method is only allowed with application/json media type.", Collections.emptyMap());
            return null;
        }
        responder.respondWith(406, "Couldn't determine a suitable media type for the given Accept header.", Collections.emptyMap());
        return null;
    }

    Optional<String> getBestMatchingMediaType(Stream<String> acceptHeaders) {
        ArrayList tupleList = new ArrayList();
        acceptHeaders.forEach(h -> {
            String[] headers;
            for (String header : headers = h.split(",")) {
                String[] parts = header.split(";");
                float prio = 1.0f;
                if (parts.length > 1) {
                    for (String x : parts) {
                        if (!x.startsWith("q=")) continue;
                        prio = Float.parseFloat(x.substring(2));
                    }
                }
                WTTuple t = new WTTuple(prio, parts[0]);
                tupleList.add(t);
            }
        });
        WTTuple bestMatchTuple = new WTTuple(-1.0f, null);
        for (WTTuple tuple : tupleList) {
            if (!this.isKnownMediaType(tuple)) continue;
            if (tuple.weight > bestMatchTuple.weight) {
                bestMatchTuple = tuple;
                continue;
            }
            if (tuple.weight != bestMatchTuple.weight || bestMatchTuple.type.equals(TEXT_PLAIN) || !tuple.type.equals(TEXT_PLAIN)) continue;
            bestMatchTuple = tuple;
        }
        if (bestMatchTuple.weight > 0.0f) {
            return bestMatchTuple.type.equals(STAR_STAR) ? Optional.of(TEXT_PLAIN) : Optional.of(bestMatchTuple.type);
        }
        return Optional.empty();
    }

    private boolean isKnownMediaType(WTTuple tuple) {
        return tuple.type.equals(TEXT_PLAIN) || tuple.type.equals(APPLICATION_JSON) || tuple.type.equals(STAR_STAR);
    }

    static {
        corsHeaders.put("Access-Control-Allow-Origin", "*");
        corsHeaders.put("Access-Control-Allow-Headers", "origin, content-type, accept, authorization");
        corsHeaders.put("Access-Control-Allow-Credentials", "true");
        corsHeaders.put("Access-Control-Allow-Methods", "GET, POST, PUT, DELETE, OPTIONS, HEAD");
    }

    private static class WTTuple {
        float weight;
        String type;

        WTTuple(float weight, String type) {
            this.weight = weight;
            this.type = type;
        }
    }

    public static interface Responder {
        public void respondWith(int var1, String var2, Map<String, String> var3) throws IOException;
    }
}

