/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.model.saml;

import java.util.List;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.federation.model.AbstractFederationResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.saml.SAMLAddHandler;
import org.wildfly.extension.picketlink.federation.model.saml.SAMLRemoveHandler;
import org.wildfly.extension.picketlink.federation.service.SAMLService;

public class SAMLResourceDefinition
extends AbstractFederationResourceDefinition {
    public static final SimpleAttributeDefinition TOKEN_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(ModelElement.SAML_TOKEN_TIMEOUT.getName(), ModelType.INT, true).setDefaultValue(new ModelNode(5000))).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition CLOCK_SKEW = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(ModelElement.SAML_CLOCK_SKEW.getName(), ModelType.INT, true).setDefaultValue(ModelNode.ZERO)).setAllowExpression(true)).build();
    public static final SAMLResourceDefinition INSTANCE = new SAMLResourceDefinition();

    private SAMLResourceDefinition() {
        super(ModelElement.SAML, ModelElement.SAML.getName(), (OperationStepHandler)SAMLAddHandler.INSTANCE, (OperationStepHandler)SAMLRemoveHandler.INSTANCE, TOKEN_TIMEOUT, CLOCK_SKEW);
    }

    @Override
    protected OperationStepHandler createAttributeWriterHandler() {
        List<SimpleAttributeDefinition> attributes = this.getAttributes();
        return new AbstractWriteAttributeHandler(attributes.toArray(new AttributeDefinition[attributes.size()])){

            protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder handbackHolder) throws OperationFailedException {
                PathAddress pathAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
                this.updateConfiguration(context, pathAddress, false);
                return false;
            }

            protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Object handback) throws OperationFailedException {
                PathAddress pathAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
                this.updateConfiguration(context, pathAddress, true);
            }

            private void updateConfiguration(OperationContext context, PathAddress pathAddress, boolean rollback) throws OperationFailedException {
                String federationAlias = pathAddress.subAddress(0, pathAddress.size() - 1).getLastElement().getValue();
                ServiceRegistry serviceRegistry = context.getServiceRegistry(false);
                ServiceController serviceController = serviceRegistry.getService(SAMLService.createServiceName(federationAlias));
                if (serviceController != null) {
                    ModelNode samlNode;
                    SAMLService service = (SAMLService)serviceController.getValue();
                    if (!rollback) {
                        samlNode = context.readResource(PathAddress.EMPTY_ADDRESS, false).getModel();
                    } else {
                        Resource rc = context.getOriginalRootResource().navigate(pathAddress);
                        samlNode = rc.getModel();
                    }
                    service.setStsType(SAMLAddHandler.toSAMLConfig(context, samlNode));
                }
            }
        };
    }
}

