/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.mwlabs.wscf.model.twophase.arjunacore;

import com.arjuna.mw.wsas.UserActivityFactory;
import com.arjuna.mw.wsas.activity.ActivityHierarchy;
import com.arjuna.mw.wsas.activity.Outcome;
import com.arjuna.mw.wsas.completionstatus.Failure;
import com.arjuna.mw.wsas.completionstatus.FailureOnly;
import com.arjuna.mw.wsas.completionstatus.Success;
import com.arjuna.mw.wsas.exceptions.ActiveChildException;
import com.arjuna.mw.wsas.exceptions.InvalidActivityException;
import com.arjuna.mw.wsas.exceptions.InvalidTimeoutException;
import com.arjuna.mw.wsas.exceptions.NoActivityException;
import com.arjuna.mw.wsas.exceptions.NoPermissionException;
import com.arjuna.mw.wsas.exceptions.ProtocolViolationException;
import com.arjuna.mw.wsas.exceptions.SystemException;
import com.arjuna.mw.wsas.exceptions.WrongStateException;
import com.arjuna.mw.wsas.status.NoActivity;
import com.arjuna.mw.wsas.status.Status;
import com.arjuna.mw.wscf.common.CoordinatorId;
import com.arjuna.mw.wscf.exceptions.DuplicateParticipantException;
import com.arjuna.mw.wscf.exceptions.InvalidParticipantException;
import com.arjuna.mw.wscf.exceptions.NoCoordinatorException;
import com.arjuna.mw.wscf.logging.wscfLogger;
import com.arjuna.mw.wscf.model.twophase.api.CoordinatorManager;
import com.arjuna.mw.wscf.model.twophase.api.UserCoordinator;
import com.arjuna.mw.wscf.model.twophase.exceptions.CoordinatorCancelledException;
import com.arjuna.mw.wscf.model.twophase.exceptions.CoordinatorConfirmedException;
import com.arjuna.mw.wscf.model.twophase.exceptions.DuplicateSynchronizationException;
import com.arjuna.mw.wscf.model.twophase.exceptions.HeuristicHazardException;
import com.arjuna.mw.wscf.model.twophase.exceptions.HeuristicMixedException;
import com.arjuna.mw.wscf.model.twophase.exceptions.InvalidSynchronizationException;
import com.arjuna.mw.wscf.model.twophase.outcomes.CoordinationOutcome;
import com.arjuna.mw.wscf.model.twophase.participants.Participant;
import com.arjuna.mw.wscf.model.twophase.participants.Synchronization;
import com.arjuna.mwlabs.wsas.UserActivityImple;
import com.arjuna.mwlabs.wsas.activity.ActivityImple;
import com.arjuna.mwlabs.wscf.model.twophase.arjunacore.CoordinatorControl;

public class CoordinatorServiceImple
implements UserCoordinator,
CoordinatorManager {
    private CoordinatorControl _coordManager = new CoordinatorControl();

    @Override
    public void begin(String serviceType) throws WrongStateException, SystemException {
        UserActivityFactory.userActivity().start(serviceType);
    }

    @Override
    public void begin(String serviceType, int timeout) throws WrongStateException, InvalidTimeoutException, SystemException {
        UserActivityFactory.userActivity().start(serviceType, timeout);
    }

    @Override
    public void confirm() throws InvalidActivityException, WrongStateException, ProtocolViolationException, NoCoordinatorException, CoordinatorCancelledException, HeuristicMixedException, HeuristicHazardException, NoPermissionException, SystemException {
        block11: {
            try {
                Outcome res = UserActivityFactory.userActivity().end(Success.instance());
                if (res == null) break block11;
                if (res instanceof CoordinationOutcome) {
                    CoordinationOutcome co = (CoordinationOutcome)res;
                    switch (co.result()) {
                        case 4: 
                        case 7: 
                        case 11: {
                            break;
                        }
                        case 3: 
                        case 10: {
                            throw new CoordinatorCancelledException();
                        }
                        case 5: {
                            throw new HeuristicMixedException();
                        }
                        case 8: {
                            throw new WrongStateException();
                        }
                        default: {
                            throw new HeuristicHazardException();
                        }
                    }
                    break block11;
                }
                throw new HeuristicHazardException(wscfLogger.i18NLogger.get_model_twophase_arjunacore_CoordinatorServiceImple_1());
            }
            catch (NoActivityException ex) {
                throw new NoCoordinatorException();
            }
            catch (ActiveChildException ex) {
            }
            catch (HeuristicHazardException ex) {
                throw ex;
            }
        }
    }

    @Override
    public void cancel() throws InvalidActivityException, WrongStateException, ProtocolViolationException, NoCoordinatorException, CoordinatorConfirmedException, HeuristicMixedException, HeuristicHazardException, NoPermissionException, SystemException {
        block11: {
            try {
                Outcome res = UserActivityFactory.userActivity().end(Failure.instance());
                if (res == null) break block11;
                if (res instanceof CoordinationOutcome) {
                    CoordinationOutcome co = (CoordinationOutcome)res;
                    switch (co.result()) {
                        case 4: 
                        case 11: {
                            throw new CoordinatorConfirmedException();
                        }
                        case 3: 
                        case 7: 
                        case 10: {
                            break;
                        }
                        case 5: {
                            throw new HeuristicMixedException();
                        }
                        case 8: {
                            throw new WrongStateException();
                        }
                        default: {
                            throw new HeuristicHazardException();
                        }
                    }
                    break block11;
                }
                throw new HeuristicHazardException(wscfLogger.i18NLogger.get_model_twophase_arjunacore_CoordinatorServiceImple_1());
            }
            catch (NoActivityException ex) {
                throw new NoCoordinatorException();
            }
            catch (ActiveChildException ex) {
            }
            catch (HeuristicHazardException ex) {
                throw ex;
            }
        }
    }

    @Override
    public void setCancelOnly() throws NoCoordinatorException, WrongStateException, SystemException {
        try {
            UserActivityFactory.userActivity().setCompletionStatus(FailureOnly.instance());
        }
        catch (NoActivityException ex) {
            throw new NoCoordinatorException();
        }
    }

    @Override
    public int getTimeout() throws SystemException {
        return UserActivityFactory.userActivity().getTimeout();
    }

    @Override
    public void setTimeout(int timeout) throws InvalidTimeoutException, SystemException {
        UserActivityFactory.userActivity().setTimeout(timeout);
    }

    @Override
    public Status status() throws SystemException {
        ActivityImple curr = this.current();
        if (curr == null) {
            return NoActivity.instance();
        }
        return this._coordManager.status();
    }

    @Override
    public ActivityHierarchy suspend() throws SystemException {
        return UserActivityFactory.userActivity().suspend();
    }

    @Override
    public void resume(ActivityHierarchy tx) throws InvalidActivityException, SystemException {
        UserActivityFactory.userActivity().resume(tx);
    }

    @Override
    public void enlistParticipant(Participant act) throws WrongStateException, DuplicateParticipantException, InvalidParticipantException, NoCoordinatorException, SystemException {
        this._coordManager.enlistParticipant(act);
    }

    @Override
    public void delistParticipant(Participant act) throws InvalidParticipantException, NoCoordinatorException, WrongStateException, SystemException {
        this._coordManager.delistParticipant(act);
    }

    @Override
    public void enlistSynchronization(Synchronization act) throws WrongStateException, DuplicateSynchronizationException, InvalidSynchronizationException, NoCoordinatorException, SystemException {
        this._coordManager.enlistSynchronization(act);
    }

    @Override
    public void delistSynchronization(Synchronization act) throws InvalidSynchronizationException, NoCoordinatorException, WrongStateException, SystemException {
        this._coordManager.delistSynchronization(act);
    }

    @Override
    public void participantRolledback(String participantId) throws NoActivityException, InvalidParticipantException, WrongStateException, SystemException {
        this._coordManager.participantRolledBack(participantId);
        try {
            this.setCancelOnly();
        }
        catch (Exception ex) {
            throw new SystemException(ex.toString());
        }
    }

    @Override
    public void participantReadOnly(String participantId) throws NoActivityException, InvalidParticipantException, SystemException {
        this._coordManager.participantReadOnly(participantId);
    }

    @Override
    public ActivityHierarchy currentActivity() throws SystemException {
        return UserActivityFactory.userActivity().currentActivity();
    }

    @Override
    public CoordinatorId identifier() throws NoActivityException, SystemException {
        ActivityImple curr = this.current();
        if (curr == null) {
            throw new NoActivityException();
        }
        return this._coordManager.identifier();
    }

    public final ActivityImple current() {
        UserActivityImple imple = (UserActivityImple)UserActivityFactory.userActivity();
        return imple.current();
    }

    public final CoordinatorControl coordinatorControl() {
        return this._coordManager;
    }
}

