/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.manager._private;

import java.io.Serializable;
import java.security.AccessControlException;
import java.security.CodeSource;
import java.security.Permission;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.Logger;
import org.wildfly.security.manager._private.SecurityMessages;

public class SecurityMessages_$logger
implements SecurityMessages,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = SecurityMessages_$logger.class.getName();
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;

    public SecurityMessages_$logger(Logger log) {
        this.log = log;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void accessCheckFailed(Permission permission, CodeSource codeSource, ClassLoader classLoader, String principals) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.accessCheckFailed4$str(), permission, codeSource, classLoader, principals);
    }

    protected String accessCheckFailed4$str() {
        return "Permission check failed (permission \"%s\" in code source \"%s\" of \"%s\", principals \"%s\")";
    }

    @Override
    public final void accessCheckFailed(Permission permission, CodeSource codeSource, ClassLoader classLoader) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.accessCheckFailed3$str(), (Object)permission, (Object)codeSource, (Object)classLoader);
    }

    protected String accessCheckFailed3$str() {
        return "Permission check failed (permission \"%s\" in code source \"%s\" of \"%s\")";
    }

    protected String accessControlException$str() {
        return "WFSM000001: Permission check failed (permission \"%s\" in code source \"%s\" of \"%s\")";
    }

    @Override
    public final AccessControlException accessControlException(Permission permission, Permission permission_, CodeSource codeSource, ClassLoader classLoader) {
        AccessControlException result = new AccessControlException(String.format(this.getLoggingLocale(), this.accessControlException$str(), permission_, codeSource, classLoader), permission);
        SecurityMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String secMgrChange$str() {
        return "WFSM000002: Security manager may not be changed";
    }

    @Override
    public final SecurityException secMgrChange() {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.secMgrChange$str(), new Object[0]));
        SecurityMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownContext$str() {
        return "WFSM000003: Unknown security context type";
    }

    @Override
    public final SecurityException unknownContext() {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.unknownContext$str(), new Object[0]));
        SecurityMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidName$str() {
        return "WFSM000006: Invalid permission name '%s'";
    }

    @Override
    public final IllegalArgumentException invalidName(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidName$str(), name));
        SecurityMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String readOnlyPermCollection$str() {
        return "WFSM000007: Permission collection is read-only";
    }

    @Override
    public final SecurityException readOnlyPermCollection() {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.readOnlyPermCollection$str(), new Object[0]));
        SecurityMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String wrongPermType$str() {
        return "WFSM000008: Invalid permission (expected an instance of %s, but got %s)";
    }

    @Override
    public final IllegalArgumentException wrongPermType(Class<? extends Permission> expectedType, Permission permission) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.wrongPermType$str(), expectedType, permission));
        SecurityMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

