/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import java.util.EnumSet;
import java.util.function.Predicate;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXMLParser;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXmlParserRegisteringProcessor;
import org.jboss.as.web.common.SharedTldsMetaDataBuilder;
import org.jboss.as.web.session.SharedSessionManagerConfig;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.undertow.RemoteHttpInvokerService;
import org.wildfly.extension.undertow.UndertowRootDefinition;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.deployment.DefaultDeploymentMappingProvider;
import org.wildfly.extension.undertow.deployment.DefaultSecurityDomainProcessor;
import org.wildfly.extension.undertow.deployment.DeploymentRootExplodedMountProcessor;
import org.wildfly.extension.undertow.deployment.EarContextRootProcessor;
import org.wildfly.extension.undertow.deployment.ExternalTldParsingDeploymentProcessor;
import org.wildfly.extension.undertow.deployment.JBossWebParsingDeploymentProcessor;
import org.wildfly.extension.undertow.deployment.SecurityDomainResolvingProcessor;
import org.wildfly.extension.undertow.deployment.ServletContainerInitializerDeploymentProcessor;
import org.wildfly.extension.undertow.deployment.SharedSessionManagerDeploymentProcessor;
import org.wildfly.extension.undertow.deployment.TldParsingDeploymentProcessor;
import org.wildfly.extension.undertow.deployment.UndertowDependencyProcessor;
import org.wildfly.extension.undertow.deployment.UndertowDeploymentProcessor;
import org.wildfly.extension.undertow.deployment.UndertowHandlersDeploymentProcessor;
import org.wildfly.extension.undertow.deployment.UndertowJSRWebSocketDeploymentProcessor;
import org.wildfly.extension.undertow.deployment.UndertowServletContainerDependencyProcessor;
import org.wildfly.extension.undertow.deployment.WarAnnotationDeploymentProcessor;
import org.wildfly.extension.undertow.deployment.WarDeploymentInitializingProcessor;
import org.wildfly.extension.undertow.deployment.WarMetaDataProcessor;
import org.wildfly.extension.undertow.deployment.WarStructureDeploymentProcessor;
import org.wildfly.extension.undertow.deployment.WebComponentProcessor;
import org.wildfly.extension.undertow.deployment.WebFragmentParsingDeploymentProcessor;
import org.wildfly.extension.undertow.deployment.WebJBossAllParser;
import org.wildfly.extension.undertow.deployment.WebParsingDeploymentProcessor;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.wildfly.extension.undertow.session.SharedSessionConfigParser;
import org.wildfly.extension.undertow.session.SharedSessionConfigSchema;

class UndertowSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    private final Predicate<String> knownSecurityDomain;

    UndertowSubsystemAdd(Predicate<String> knownSecurityDomain) {
        super(UndertowRootDefinition.ATTRIBUTES);
        this.knownSecurityDomain = knownSecurityDomain;
    }

    protected void performBoottime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        try {
            Class.forName("org.apache.jasper.compiler.JspRuntimeContext", true, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            UndertowLogger.ROOT_LOGGER.couldNotInitJsp(e);
        }
        final ModelNode model = resource.getModel();
        final String defaultVirtualHost = UndertowRootDefinition.DEFAULT_VIRTUAL_HOST.resolveModelAttribute(context, model).asString();
        final String defaultContainer = UndertowRootDefinition.DEFAULT_SERVLET_CONTAINER.resolveModelAttribute(context, model).asString();
        final String defaultServer = UndertowRootDefinition.DEFAULT_SERVER.resolveModelAttribute(context, model).asString();
        boolean stats = UndertowRootDefinition.STATISTICS_ENABLED.resolveModelAttribute(context, model).asBoolean();
        final String defaultSecurityDomain = UndertowRootDefinition.DEFAULT_SECURITY_DOMAIN.resolveModelAttribute(context, model).asString();
        ModelNode instanceIdModel = UndertowRootDefinition.INSTANCE_ID.resolveModelAttribute(context, model);
        String instanceId = instanceIdModel.isDefined() ? instanceIdModel.asString() : null;
        DefaultDeploymentMappingProvider.instance().clear();
        context.getCapabilityServiceTarget().addCapability(UndertowRootDefinition.UNDERTOW_CAPABILITY).setInstance((Service)new UndertowService(defaultContainer, defaultServer, defaultVirtualHost, instanceId, stats)).setInitialMode(ServiceController.Mode.ACTIVE).addAliases(new ServiceName[]{UndertowService.UNDERTOW}).install();
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                SharedTldsMetaDataBuilder sharedTldsBuilder = new SharedTldsMetaDataBuilder(model.clone());
                processorTarget.addDeploymentProcessor("undertow", Phase.STRUCTURE, 256, (DeploymentUnitProcessor)new DeploymentRootExplodedMountProcessor());
                JBossAllXmlParserRegisteringProcessor.Builder builder = JBossAllXmlParserRegisteringProcessor.builder();
                for (SharedSessionConfigSchema schema : EnumSet.allOf(SharedSessionConfigSchema.class)) {
                    builder.addParser(schema.getRoot(), SharedSessionManagerConfig.ATTACHMENT_KEY, (JBossAllXMLParser)new SharedSessionConfigParser(schema));
                }
                processorTarget.addDeploymentProcessor("undertow", Phase.STRUCTURE, 2586, (DeploymentUnitProcessor)builder.build());
                processorTarget.addDeploymentProcessor("undertow", Phase.STRUCTURE, 2580, (DeploymentUnitProcessor)new JBossAllXmlParserRegisteringProcessor(WebJBossAllParser.ROOT_ELEMENT, WebJBossAllParser.ATTACHMENT_KEY, (JBossAllXMLParser)new WebJBossAllParser()));
                processorTarget.addDeploymentProcessor("undertow", Phase.STRUCTURE, 2048, (DeploymentUnitProcessor)new WarDeploymentInitializingProcessor());
                processorTarget.addDeploymentProcessor("undertow", Phase.STRUCTURE, 2304, (DeploymentUnitProcessor)new WarStructureDeploymentProcessor(sharedTldsBuilder));
                processorTarget.addDeploymentProcessor("undertow", Phase.PARSE, 2816, (DeploymentUnitProcessor)new WebParsingDeploymentProcessor());
                processorTarget.addDeploymentProcessor("undertow", Phase.PARSE, 3072, (DeploymentUnitProcessor)new WebFragmentParsingDeploymentProcessor());
                processorTarget.addDeploymentProcessor("undertow", Phase.PARSE, 3584, (DeploymentUnitProcessor)new JBossWebParsingDeploymentProcessor());
                processorTarget.addDeploymentProcessor("undertow", Phase.PARSE, 3328, (DeploymentUnitProcessor)new WarAnnotationDeploymentProcessor());
                processorTarget.addDeploymentProcessor("undertow", Phase.PARSE, 4096, (DeploymentUnitProcessor)new EarContextRootProcessor());
                processorTarget.addDeploymentProcessor("undertow", Phase.PARSE, 8192, (DeploymentUnitProcessor)new WarMetaDataProcessor());
                processorTarget.addDeploymentProcessor("undertow", Phase.PARSE, 8196, (DeploymentUnitProcessor)new TldParsingDeploymentProcessor());
                processorTarget.addDeploymentProcessor("undertow", Phase.PARSE, 8200, (DeploymentUnitProcessor)new WebComponentProcessor());
                processorTarget.addDeploymentProcessor("undertow", Phase.PARSE, 8204, (DeploymentUnitProcessor)new DefaultSecurityDomainProcessor(defaultSecurityDomain));
                processorTarget.addDeploymentProcessor("undertow", Phase.DEPENDENCIES, 1792, (DeploymentUnitProcessor)new UndertowDependencyProcessor());
                processorTarget.addDeploymentProcessor("undertow", Phase.POST_MODULE, 11776, (DeploymentUnitProcessor)new UndertowJSRWebSocketDeploymentProcessor());
                processorTarget.addDeploymentProcessor("undertow", Phase.POST_MODULE, 12032, (DeploymentUnitProcessor)new UndertowHandlersDeploymentProcessor());
                processorTarget.addDeploymentProcessor("undertow", Phase.POST_MODULE, 12048, (DeploymentUnitProcessor)new ExternalTldParsingDeploymentProcessor());
                processorTarget.addDeploymentProcessor("undertow", Phase.POST_MODULE, 12058, (DeploymentUnitProcessor)new UndertowServletContainerDependencyProcessor(defaultContainer));
                processorTarget.addDeploymentProcessor("undertow", Phase.INSTALL, 256, (DeploymentUnitProcessor)new SharedSessionManagerDeploymentProcessor(defaultServer));
                processorTarget.addDeploymentProcessor("undertow", Phase.INSTALL, 4864, (DeploymentUnitProcessor)new ServletContainerInitializerDeploymentProcessor());
                processorTarget.addDeploymentProcessor("undertow", Phase.INSTALL, 7423, (DeploymentUnitProcessor)new SecurityDomainResolvingProcessor(defaultSecurityDomain, UndertowSubsystemAdd.this.knownSecurityDomain));
                processorTarget.addDeploymentProcessor("undertow", Phase.INSTALL, 7424, (DeploymentUnitProcessor)new UndertowDeploymentProcessor(defaultVirtualHost, defaultContainer, defaultServer, UndertowSubsystemAdd.this.knownSecurityDomain));
            }
        }, OperationContext.Stage.RUNTIME);
        context.getCapabilityServiceTarget().addCapability(UndertowRootDefinition.HTTP_INVOKER_RUNTIME_CAPABILITY).setInstance((Service)new RemoteHttpInvokerService()).install();
    }
}

