/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryExpired;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryModified;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryRemoved;
import org.infinispan.client.hotrod.annotation.ClientCacheFailover;
import org.infinispan.client.hotrod.event.ClientCacheEntryCreatedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryCustomEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryExpiredEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryModifiedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryRemovedEvent;
import org.infinispan.client.hotrod.event.ClientCacheFailoverEvent;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.client.hotrod.event.impl.EventDispatcher;
import org.infinispan.client.hotrod.event.impl.SecurityActions;
import org.infinispan.client.hotrod.impl.operations.AddClientListenerOperation;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.commons.util.Util;

public final class ClientEventDispatcher
extends EventDispatcher<ClientEvent> {
    public static final ClientCacheFailoverEvent FAILOVER_EVENT_SINGLETON = () -> ClientEvent.Type.CLIENT_CACHE_FAILOVER;
    private static final Map<Class<? extends Annotation>, Class<?>[]> allowedListeners = new HashMap<Class<? extends Annotation>, Class<?>[]>(5);
    private final Map<Class<? extends Annotation>, List<ClientListenerInvocation>> invocables;
    private final AddClientListenerOperation op;

    ClientEventDispatcher(AddClientListenerOperation op, SocketAddress address, Map<Class<? extends Annotation>, List<ClientListenerInvocation>> invocables, String cacheName, Runnable cleanup) {
        super(cacheName, op.listener, op.listenerId, address, cleanup);
        this.op = op;
        this.invocables = invocables;
    }

    public static ClientEventDispatcher create(AddClientListenerOperation op, SocketAddress address, Runnable cleanup) {
        Map<Class<? extends Annotation>, List<ClientListenerInvocation>> invocables = ClientEventDispatcher.findMethods(op.listener);
        return new ClientEventDispatcher(op, address, invocables, op.getCacheName(), cleanup);
    }

    public static Map<Class<? extends Annotation>, List<ClientListenerInvocation>> findMethods(Object listener) {
        HashMap<Class<? extends Annotation>, List<ClientListenerInvocation>> listenerMethodMap = new HashMap<Class<? extends Annotation>, List<ClientListenerInvocation>>(4, 0.99f);
        for (Method m : listener.getClass().getMethods()) {
            for (Map.Entry<Class<? extends Annotation>, Class<?>[]> entry : allowedListeners.entrySet()) {
                Class<? extends Annotation> annotationType = entry.getKey();
                Class<?>[] eventTypes = entry.getValue();
                if (!m.isAnnotationPresent(annotationType)) continue;
                ClientEventDispatcher.testListenerMethodValidity(m, eventTypes, annotationType.getName());
                SecurityActions.setAccessible(m);
                ClientListenerInvocation invocation = new ClientListenerInvocation(listener, m);
                listenerMethodMap.computeIfAbsent(annotationType, a -> new ArrayList()).add(invocation);
            }
        }
        return listenerMethodMap;
    }

    static void testListenerMethodValidity(Method m, Class<?>[] allowedParameters, String annotationName) {
        boolean isAllowed = false;
        for (Class<?> allowedParameter : allowedParameters) {
            if (m.getParameterTypes().length != 1 || !m.getParameterTypes()[0].isAssignableFrom(allowedParameter)) continue;
            isAllowed = true;
            break;
        }
        if (!isAllowed) {
            throw Log.HOTROD.incorrectClientListener(annotationName, Arrays.asList(allowedParameters));
        }
        if (!m.getReturnType().equals(Void.TYPE)) {
            throw Log.HOTROD.incorrectClientListener(annotationName);
        }
    }

    @Override
    public void invokeEvent(ClientEvent clientEvent) {
        if (trace) {
            log.tracef("Event %s received for listener with id=%s", clientEvent, Util.printArray((byte[])this.listenerId));
        }
        switch (clientEvent.getType()) {
            case CLIENT_CACHE_ENTRY_CREATED: {
                this.invokeCallbacks(clientEvent, ClientCacheEntryCreated.class);
                break;
            }
            case CLIENT_CACHE_ENTRY_MODIFIED: {
                this.invokeCallbacks(clientEvent, ClientCacheEntryModified.class);
                break;
            }
            case CLIENT_CACHE_ENTRY_REMOVED: {
                this.invokeCallbacks(clientEvent, ClientCacheEntryRemoved.class);
                break;
            }
            case CLIENT_CACHE_ENTRY_EXPIRED: {
                this.invokeCallbacks(clientEvent, ClientCacheEntryExpired.class);
            }
        }
    }

    private void invokeCallbacks(ClientEvent event, Class<? extends Annotation> type) {
        List<ClientListenerInvocation> callbacks = this.invocables.get(type);
        if (callbacks != null) {
            for (ClientListenerInvocation callback : callbacks) {
                callback.invoke(event);
            }
        }
    }

    @Override
    public CompletableFuture<Short> executeFailover() {
        return this.op.copy().execute();
    }

    @Override
    protected void invokeFailoverEvent() {
        List<ClientListenerInvocation> callbacks = this.invocables.get(ClientCacheFailover.class);
        if (callbacks != null) {
            for (ClientListenerInvocation callback : callbacks) {
                callback.invoke(FAILOVER_EVENT_SINGLETON);
            }
        }
    }

    protected DataFormat getDataFormat() {
        return this.op.getDataFormat();
    }

    static {
        allowedListeners.put(ClientCacheEntryCreated.class, new Class[]{ClientCacheEntryCreatedEvent.class, ClientCacheEntryCustomEvent.class});
        allowedListeners.put(ClientCacheEntryModified.class, new Class[]{ClientCacheEntryModifiedEvent.class, ClientCacheEntryCustomEvent.class});
        allowedListeners.put(ClientCacheEntryRemoved.class, new Class[]{ClientCacheEntryRemovedEvent.class, ClientCacheEntryCustomEvent.class});
        allowedListeners.put(ClientCacheEntryExpired.class, new Class[]{ClientCacheEntryExpiredEvent.class, ClientCacheEntryCustomEvent.class});
        allowedListeners.put(ClientCacheFailover.class, new Class[]{ClientCacheFailoverEvent.class});
    }

    static final class ClientListenerInvocation {
        final Object listener;
        final Method method;

        private ClientListenerInvocation(Object listener, Method method) {
            this.listener = listener;
            this.method = method;
        }

        public void invoke(ClientEvent event) {
            try {
                this.method.invoke(this.listener, event);
            }
            catch (Exception e) {
                throw Log.HOTROD.exceptionInvokingListener(e.getClass().getName(), this.method, this.listener, e);
            }
        }
    }
}

