/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem.remote;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.management.MBeanServer;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.configuration.ClusterConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ConnectionPoolConfiguration;
import org.infinispan.client.hotrod.configuration.ExecutorFactoryConfiguration;
import org.infinispan.client.hotrod.configuration.SecurityConfiguration;
import org.infinispan.client.hotrod.configuration.TransactionConfiguration;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.marshall.Marshaller;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityServiceNameProvider;
import org.jboss.as.clustering.controller.CommonRequirement;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.controller.ResourceServiceConfigurator;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.MBeanServerProvider;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPoolResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheContainerComponent;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteClusterResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.infinispan.marshalling.jboss.JBossMarshaller;
import org.wildfly.clustering.infinispan.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ModuleClassResolver;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;

public class RemoteCacheContainerConfigurationServiceConfigurator
extends CapabilityServiceNameProvider
implements ResourceServiceConfigurator,
Supplier<Configuration> {
    private final Map<String, List<SupplierDependency<OutboundSocketBinding>>> clusters = new HashMap<String, List<SupplierDependency<OutboundSocketBinding>>>();
    private final Map<ThreadPoolResourceDefinition, SupplierDependency<ExecutorFactoryConfiguration>> threadPools = new EnumMap<ThreadPoolResourceDefinition, SupplierDependency<ExecutorFactoryConfiguration>>(ThreadPoolResourceDefinition.class);
    private final SupplierDependency<ModuleLoader> loader;
    private final SupplierDependency<Module> module;
    private final Properties properties = new Properties();
    private final SupplierDependency<ConnectionPoolConfiguration> connectionPool;
    private final SupplierDependency<SecurityConfiguration> security;
    private final SupplierDependency<TransactionConfiguration> transaction;
    private volatile SupplierDependency<MBeanServer> server;
    private volatile int connectionTimeout;
    private volatile String defaultRemoteCluster;
    private volatile int keySizeEstimate;
    private volatile int maxRetries;
    private volatile String protocolVersion;
    private volatile int socketTimeout;
    private volatile boolean tcpNoDelay;
    private volatile boolean tcpKeepAlive;
    private volatile int valueSizeEstimate;
    private volatile boolean statisticsEnabled;

    RemoteCacheContainerConfigurationServiceConfigurator(PathAddress address) {
        super((Capability)RemoteCacheContainerResourceDefinition.Capability.CONFIGURATION, address);
        this.loader = new ServiceSupplierDependency(Services.JBOSS_SERVICE_MODULE_LOADER);
        this.threadPools.put(ThreadPoolResourceDefinition.CLIENT, (SupplierDependency<ExecutorFactoryConfiguration>)new ServiceSupplierDependency(ThreadPoolResourceDefinition.CLIENT.getServiceName(address)));
        this.module = new ServiceSupplierDependency(RemoteCacheContainerComponent.MODULE.getServiceName(address));
        this.connectionPool = new ServiceSupplierDependency(RemoteCacheContainerComponent.CONNECTION_POOL.getServiceName(address));
        this.security = new ServiceSupplierDependency(RemoteCacheContainerComponent.SECURITY.getServiceName(address));
        this.transaction = new ServiceSupplierDependency(RemoteCacheContainerComponent.TRANSACTION.getServiceName(address));
    }

    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.connectionTimeout = RemoteCacheContainerResourceDefinition.Attribute.CONNECTION_TIMEOUT.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        this.defaultRemoteCluster = RemoteCacheContainerResourceDefinition.Attribute.DEFAULT_REMOTE_CLUSTER.resolveModelAttribute((ExpressionResolver)context, model).asString();
        this.keySizeEstimate = RemoteCacheContainerResourceDefinition.Attribute.KEY_SIZE_ESTIMATE.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        this.maxRetries = RemoteCacheContainerResourceDefinition.Attribute.MAX_RETRIES.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        this.protocolVersion = RemoteCacheContainerResourceDefinition.Attribute.PROTOCOL_VERSION.resolveModelAttribute((ExpressionResolver)context, model).asString();
        this.socketTimeout = RemoteCacheContainerResourceDefinition.Attribute.SOCKET_TIMEOUT.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        this.tcpNoDelay = RemoteCacheContainerResourceDefinition.Attribute.TCP_NO_DELAY.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        this.tcpKeepAlive = RemoteCacheContainerResourceDefinition.Attribute.TCP_KEEP_ALIVE.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        this.valueSizeEstimate = RemoteCacheContainerResourceDefinition.Attribute.VALUE_SIZE_ESTIMATE.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        this.statisticsEnabled = RemoteCacheContainerResourceDefinition.Attribute.STATISTICS_ENABLED.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        this.clusters.clear();
        Resource container = context.readResource(PathAddress.EMPTY_ADDRESS);
        for (Resource.ResourceEntry entry : container.getChildren(RemoteClusterResourceDefinition.WILDCARD_PATH.getKey())) {
            String clusterName = entry.getName();
            ModelNode cluster = entry.getModel();
            List bindings = StringListAttributeDefinition.unwrapValue((ExpressionResolver)context, (ModelNode)RemoteClusterResourceDefinition.Attribute.SOCKET_BINDINGS.resolveModelAttribute((ExpressionResolver)context, cluster));
            ArrayList<ServiceSupplierDependency> bindingDependencies = new ArrayList<ServiceSupplierDependency>(bindings.size());
            for (String binding : bindings) {
                bindingDependencies.add(new ServiceSupplierDependency(CommonUnaryRequirement.OUTBOUND_SOCKET_BINDING.getServiceName(context, binding)));
            }
            this.clusters.put(clusterName, bindingDependencies);
        }
        this.server = context.hasOptionalCapability(CommonRequirement.MBEAN_SERVER.getName(), null, null) ? new ServiceSupplierDependency(CommonRequirement.MBEAN_SERVER.getServiceName(context)) : null;
        this.properties.clear();
        for (Property property : ModelNodes.optionalPropertyList((ModelNode)RemoteCacheContainerResourceDefinition.Attribute.PROPERTIES.resolveModelAttribute((ExpressionResolver)context, model)).orElse(Collections.emptyList())) {
            this.properties.setProperty(property.getName(), property.getValue().asString());
        }
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer configuration = new CompositeDependency(new Dependency[]{this.loader, this.module, this.connectionPool, this.security, this.transaction, this.server}).register(builder).provides(new ServiceName[]{this.getServiceName()});
        for (Dependency dependency : this.threadPools.values()) {
            dependency.register(builder);
        }
        for (List list : this.clusters.values()) {
            for (Dependency dependency : list) {
                dependency.register(builder);
            }
        }
        FunctionalService service = new FunctionalService(configuration, Function.identity(), (Supplier)this);
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    public Configuration get() {
        String name = this.getServiceName().getSimpleName();
        MBeanServer server = this.server != null ? (MBeanServer)this.server.get() : null;
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.security().read((SecurityConfiguration)this.security.get());
        builder.withProperties(this.properties).connectionTimeout(this.connectionTimeout).keySizeEstimate(this.keySizeEstimate).maxRetries(this.maxRetries).version(ProtocolVersion.parseVersion((String)this.protocolVersion)).socketTimeout(this.socketTimeout).statistics().enabled(this.statisticsEnabled).jmxDomain("org.wildfly.clustering.infinispan").jmxEnabled(server != null).jmxName(name).mBeanServerLookup((MBeanServerLookup)new MBeanServerProvider(server)).tcpNoDelay(this.tcpNoDelay).tcpKeepAlive(this.tcpKeepAlive).valueSizeEstimate(this.valueSizeEstimate);
        ModuleClassLoader loader = ((Module)this.module.get()).getClassLoader();
        Marshaller marshaller = this.createMarshaller((ClassLoader)loader);
        InfinispanLogger.ROOT_LOGGER.debugf("%s cache-container will use %s", name, marshaller.getClass().getName());
        builder.marshaller(marshaller);
        builder.connectionPool().read((ConnectionPoolConfiguration)this.connectionPool.get());
        builder.asyncExecutorFactory().read((ExecutorFactoryConfiguration)this.threadPools.get(ThreadPoolResourceDefinition.CLIENT).get());
        for (Map.Entry<String, List<SupplierDependency<OutboundSocketBinding>>> cluster : this.clusters.entrySet()) {
            String clusterName = cluster.getKey();
            List<SupplierDependency<OutboundSocketBinding>> bindingDependencies = cluster.getValue();
            if (this.defaultRemoteCluster.equals(clusterName)) {
                for (Supplier supplier : bindingDependencies) {
                    OutboundSocketBinding outboundSocketBinding = (OutboundSocketBinding)supplier.get();
                    builder.addServer().host(outboundSocketBinding.getUnresolvedDestinationAddress()).port(outboundSocketBinding.getDestinationPort());
                }
                continue;
            }
            ClusterConfigurationBuilder clusterConfigurationBuilder = builder.addCluster(clusterName);
            for (Supplier supplier : bindingDependencies) {
                OutboundSocketBinding binding = (OutboundSocketBinding)supplier.get();
                clusterConfigurationBuilder.addClusterNode(binding.getUnresolvedDestinationAddress(), binding.getDestinationPort());
            }
        }
        builder.transaction().read((TransactionConfiguration)this.transaction.get());
        return builder.build();
    }

    private Marshaller createMarshaller(ClassLoader loader) {
        ModuleLoader moduleLoader = (ModuleLoader)this.loader.get();
        try {
            return new ProtoStreamMarshaller((org.wildfly.clustering.marshalling.protostream.ClassResolver)new ModuleClassResolver(moduleLoader), loader);
        }
        catch (NoSuchElementException e) {
            return new JBossMarshaller((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)moduleLoader), loader);
        }
    }
}

