/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.wildfly.security.manager.WildFlySecurityManager;

public abstract class AbstractSerializationContextInitializer
implements SerializationContextInitializer {
    private final String resourceName;

    protected AbstractSerializationContextInitializer() {
        this.resourceName = this.getClass().getPackage().getName() + ".proto";
    }

    protected AbstractSerializationContextInitializer(String resourceName) {
        this.resourceName = resourceName;
    }

    @Deprecated
    public final String getProtoFileName() {
        return null;
    }

    @Deprecated
    public final String getProtoFile() {
        return null;
    }

    public void registerSchema(SerializationContext context) {
        ClassLoader loader = WildFlySecurityManager.getClassLoaderPrivileged(this.getClass());
        try {
            context.registerProtoFiles(FileDescriptorSource.fromResources((ClassLoader)loader, (String[])new String[]{this.resourceName}));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

