/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.OptionalInt;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.infinispan.protostream.impl.RawProtoStreamWriterImpl;
import org.wildfly.clustering.marshalling.protostream.Any;
import org.wildfly.clustering.marshalling.protostream.AnyMarshaller;
import org.wildfly.clustering.marshalling.protostream.Predictable;
import org.wildfly.clustering.marshalling.spi.ByteBufferOutputStream;

public class ProtoStreamObjectOutput
implements ObjectOutput {
    private final ImmutableSerializationContext context;
    private final RawProtoStreamWriter writer;

    public ProtoStreamObjectOutput(ImmutableSerializationContext context, RawProtoStreamWriter writer) {
        this.context = context;
        this.writer = writer;
    }

    @Override
    public void writeBoolean(boolean value) throws IOException {
        RawProtoStreamWriterImpl writer = (RawProtoStreamWriterImpl)this.writer;
        writer.getDelegate().writeBoolNoTag(value);
    }

    @Override
    public void writeByte(int value) throws IOException {
        RawProtoStreamWriterImpl writer = (RawProtoStreamWriterImpl)this.writer;
        writer.getDelegate().writeRawByte((byte)value);
    }

    @Override
    public void writeShort(int value) throws IOException {
        RawProtoStreamWriterImpl writer = (RawProtoStreamWriterImpl)this.writer;
        writer.getDelegate().writeRawByte((byte)(0xFF & value >> 8));
        writer.getDelegate().writeRawByte((byte)(0xFF & value));
    }

    @Override
    public void writeChar(int value) throws IOException {
        this.writer.writeUInt32NoTag(value);
    }

    @Override
    public void writeInt(int value) throws IOException {
        RawProtoStreamWriterImpl writer = (RawProtoStreamWriterImpl)this.writer;
        writer.getDelegate().writeSInt32NoTag(value);
    }

    @Override
    public void writeLong(long value) throws IOException {
        RawProtoStreamWriterImpl writer = (RawProtoStreamWriterImpl)this.writer;
        writer.getDelegate().writeSInt64NoTag(value);
    }

    @Override
    public void writeFloat(float value) throws IOException {
        RawProtoStreamWriterImpl writer = (RawProtoStreamWriterImpl)this.writer;
        writer.getDelegate().writeFloatNoTag(value);
    }

    @Override
    public void writeDouble(double value) throws IOException {
        RawProtoStreamWriterImpl writer = (RawProtoStreamWriterImpl)this.writer;
        writer.getDelegate().writeDoubleNoTag(value);
    }

    @Override
    public void writeBytes(String value) throws IOException {
        for (int i = 0; i < value.length(); ++i) {
            this.writeByte(value.charAt(i));
        }
    }

    @Override
    public void writeChars(String value) throws IOException {
        for (int i = 0; i < value.length(); ++i) {
            this.writeShort(value.charAt(i));
        }
    }

    @Override
    public void writeUTF(String value) throws IOException {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        this.writeChar(bytes.length);
        this.write(bytes);
    }

    @Override
    public void writeObject(Object object) throws IOException {
        Any any;
        AnyMarshaller marshaller = (AnyMarshaller)this.context.getMarshaller(Any.class);
        OptionalInt size = marshaller.size(this.context, any = new Any(object));
        try (ByteBufferOutputStream output = new ByteBufferOutputStream(size.isPresent() ? OptionalInt.of(Predictable.byteArraySize(size.getAsInt())) : OptionalInt.empty());){
            ProtobufUtil.writeTo((ImmutableSerializationContext)this.context, (OutputStream)output, (Object)any);
            ByteBuffer buffer = output.getBuffer();
            int offset = buffer.arrayOffset();
            int length = buffer.limit() - offset;
            this.writeChar(length);
            this.write(buffer.array(), offset, length);
        }
    }

    @Override
    public void write(int value) throws IOException {
        this.writeByte(value);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        this.writer.writeRawBytes(bytes, offset, length);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }
}

