/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.concurrent.CompletionStage;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.InvocationExceptionFunction;
import org.infinispan.interceptors.distribution.ConcurrentChangeException;
import org.infinispan.interceptors.impl.EntryWrappingInterceptor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RetryingEntryWrappingInterceptor
extends EntryWrappingInterceptor {
    private static final Log log = LogFactory.getLog(EntryWrappingInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    private final InvocationExceptionFunction<DataWriteCommand> handleDataWriteReturn = this::handleDataWriteReturn;
    private final InvocationExceptionFunction<WriteCommand> handleManyWriteReturn = this::handleManyWriteReturn;

    @Override
    protected Object setSkipRemoteGetsAndInvokeNextForDataCommand(InvocationContext ctx, DataWriteCommand command, CompletionStage<Void> delay) {
        return RetryingEntryWrappingInterceptor.makeStage(this.asyncInvokeNext(ctx, (VisitableCommand)command, delay)).andExceptionally(ctx, command, this.handleDataWriteReturn);
    }

    Object handleDataWriteReturn(InvocationContext ctx, DataWriteCommand dataWriteCommand, Throwable throwable) throws Throwable {
        if (throwable instanceof ConcurrentChangeException) {
            if (trace) {
                log.tracef(throwable, "Retrying %s after concurrent change", dataWriteCommand);
            }
            ctx.removeLookedUpEntry(dataWriteCommand.getKey());
            return this.visitCommand(ctx, dataWriteCommand);
        }
        throw throwable;
    }

    @Override
    protected Object setSkipRemoteGetsAndInvokeNextForManyEntriesCommand(InvocationContext ctx, WriteCommand command, CompletionStage<Void> delay) {
        return RetryingEntryWrappingInterceptor.makeStage(this.asyncInvokeNext(ctx, (VisitableCommand)command, delay)).andExceptionally(ctx, command, this.handleManyWriteReturn);
    }

    Object handleManyWriteReturn(InvocationContext ctx, WriteCommand command, Throwable throwable) throws Throwable {
        if (throwable instanceof ConcurrentChangeException) {
            if (trace) {
                log.tracef(throwable, "Retrying %s after concurrent change", command);
            }
            for (Object key : command.getAffectedKeys()) {
                MVCCEntry entry = (MVCCEntry)ctx.lookupEntry(key);
                if (entry.isCommitted()) {
                    entry.resetCurrentValue();
                    continue;
                }
                ctx.removeLookedUpEntry(key);
            }
            return this.visitCommand(ctx, command);
        }
        throw throwable;
    }
}

