/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.health.deployment;

import io.smallrye.health.SmallRyeHealthReporter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.util.AnnotationLiteral;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.health.Health;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.Liveness;
import org.eclipse.microprofile.health.Readiness;
import org.jboss.modules.Module;
import org.wildfly.extension.microprofile.health.MicroProfileHealthReporter;

public class CDIExtension
implements Extension {
    private final MicroProfileHealthReporter reporter;
    private final Module module;
    private Instance<Object> instance;
    private final List<HealthCheck> healthChecks = new ArrayList<HealthCheck>();
    private final List<HealthCheck> livenessChecks = new ArrayList<HealthCheck>();
    private final List<HealthCheck> readinessChecks = new ArrayList<HealthCheck>();
    private HealthCheck defaultReadinessCheck;

    public CDIExtension(MicroProfileHealthReporter healthReporter, Module module) {
        this.reporter = healthReporter;
        this.module = module;
    }

    private void afterDeploymentValidation(@Observes AfterDeploymentValidation avd, BeanManager bm) {
        Config config;
        boolean disableDefaultprocedure;
        this.instance = bm.createInstance();
        this.addHealthChecks(HealthLiteral.INSTANCE, this.reporter::addHealthCheck, this.healthChecks);
        this.addHealthChecks((AnnotationLiteral)Liveness.Literal.INSTANCE, this.reporter::addLivenessCheck, this.livenessChecks);
        this.addHealthChecks((AnnotationLiteral)Readiness.Literal.INSTANCE, this.reporter::addReadinessCheck, this.readinessChecks);
        if (this.readinessChecks.isEmpty() && !(disableDefaultprocedure = (config = ConfigProvider.getConfig((ClassLoader)this.module.getClassLoader())).getOptionalValue("mp.health.disable-default-procedures", Boolean.class).orElse(false).booleanValue())) {
            this.defaultReadinessCheck = new DefaultReadinessHealthCheck(this.module.getName());
            this.reporter.addReadinessCheck(this.defaultReadinessCheck, (ClassLoader)this.module.getClassLoader());
        }
    }

    private void addHealthChecks(AnnotationLiteral qualifier, BiConsumer<HealthCheck, ClassLoader> healthFunction, List<HealthCheck> healthChecks) {
        for (HealthCheck healthCheck : this.instance.select(HealthCheck.class, new Annotation[]{qualifier})) {
            healthFunction.accept(healthCheck, (ClassLoader)this.module.getClassLoader());
            healthChecks.add(healthCheck);
        }
    }

    public void beforeShutdown(@Observes BeforeShutdown bs) {
        this.removeHealthCheck(this.healthChecks, this.reporter::removeHealthCheck);
        this.removeHealthCheck(this.livenessChecks, this.reporter::removeLivenessCheck);
        this.removeHealthCheck(this.readinessChecks, this.reporter::removeReadinessCheck);
        if (this.defaultReadinessCheck != null) {
            this.reporter.removeReadinessCheck(this.defaultReadinessCheck);
            this.defaultReadinessCheck = null;
        }
        this.instance = null;
    }

    private void removeHealthCheck(List<HealthCheck> healthChecks, Consumer<HealthCheck> healthFunction) {
        for (HealthCheck healthCheck : healthChecks) {
            healthFunction.accept(healthCheck);
            this.instance.destroy((Object)healthCheck);
        }
        healthChecks.clear();
    }

    public void vetoSmallryeHealthReporter(@Observes ProcessAnnotatedType<SmallRyeHealthReporter> pat) {
        pat.veto();
    }

    private static final class DefaultReadinessHealthCheck
    implements HealthCheck {
        private final String deploymentName;

        DefaultReadinessHealthCheck(String deploymentName) {
            this.deploymentName = deploymentName;
        }

        public HealthCheckResponse call() {
            return HealthCheckResponse.named((String)("ready-" + this.deploymentName)).up().build();
        }
    }

    static final class HealthLiteral
    extends AnnotationLiteral<Health>
    implements Health {
        static final HealthLiteral INSTANCE = new HealthLiteral();
        private static final long serialVersionUID = 1L;

        HealthLiteral() {
        }
    }
}

