/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.wildfly.idp;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.impl.ClientCertAuthenticationMechanism;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.handlers.security.ServletFormAuthenticationMechanism;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import org.picketlink.config.federation.IDPType;
import org.picketlink.config.federation.PicketLinkType;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditHelper;

public class IDPAuthenticationMechanism
extends ServletFormAuthenticationMechanism {
    private final PicketLinkType configuration;
    private final ClientCertAuthenticationMechanism clientCertAuthMech;

    public IDPAuthenticationMechanism(FormParserFactory formParserFactory, String mechanismName, String loginPage, String errorPage, PicketLinkType configuration, PicketLinkAuditHelper auditHelper) {
        super(formParserFactory, mechanismName, loginPage, errorPage);
        this.configuration = configuration;
        this.clientCertAuthMech = new ClientCertAuthenticationMechanism(true);
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        IDPType idpType = (IDPType)this.configuration.getIdpOrSP();
        AuthenticationMechanism.AuthenticationMechanismOutcome outcome = null;
        if (idpType.isSSLClientAuthentication()) {
            outcome = this.clientCertAuthMech.authenticate(exchange, securityContext);
        }
        if (outcome == null || !AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED.equals(outcome)) {
            outcome = super.authenticate(exchange, securityContext);
        }
        return outcome;
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpServletRequest request = (HttpServletRequest)servletRequestContext.getServletRequest();
        Principal principal = request.getUserPrincipal();
        if (this.isAjaxRequest(request) && principal == null) {
            return new AuthenticationMechanism.ChallengeResult(false, Integer.valueOf(403));
        }
        return super.sendChallenge(exchange, securityContext);
    }

    private boolean isAjaxRequest(HttpServletRequest request) {
        String requestedWithHeader = request.getHeader("X-Requested-With");
        return requestedWithHeader != null && "XMLHttpRequest".equalsIgnoreCase(requestedWithHeader);
    }
}

