/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util.concurrent.atomic;

import java.io.IOException;
import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.infinispan.protostream.impl.RawProtoStreamWriterImpl;
import org.wildfly.clustering.marshalling.protostream.ExternalizerMarshaller;
import org.wildfly.clustering.marshalling.protostream.FunctionalObjectMarshaller;
import org.wildfly.clustering.marshalling.protostream.MarshallerProvider;
import org.wildfly.clustering.marshalling.protostream.Predictable;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.spi.util.concurrent.atomic.AtomicExternalizerProvider;

public enum AtomicMarshaller implements MarshallerProvider
{
    BOOLEAN((Class)AtomicBoolean.class){
        private final ProtoStreamMarshaller<AtomicBoolean> marshaller = new ExternalizerMarshaller<AtomicBoolean>(AtomicExternalizerProvider.ATOMIC_BOOLEAN.cast(AtomicBoolean.class));

        @Override
        public ProtoStreamMarshaller<?> getMarshaller() {
            return this.marshaller;
        }
    }
    ,
    INTEGER((Class)AtomicInteger.class){

        @Override
        public AtomicInteger readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
            return new AtomicInteger(reader.readSInt32());
        }

        @Override
        public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Object value) throws IOException {
            ((RawProtoStreamWriterImpl)writer).getDelegate().writeSInt32NoTag(((AtomicInteger)value).intValue());
        }

        @Override
        public OptionalInt size(ImmutableSerializationContext context, Object value) {
            return OptionalInt.of(Predictable.signedIntSize(((AtomicInteger)value).intValue()));
        }
    }
    ,
    LONG((Class)AtomicLong.class){

        @Override
        public AtomicLong readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
            return new AtomicLong(reader.readSInt64());
        }

        @Override
        public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Object value) throws IOException {
            ((RawProtoStreamWriterImpl)writer).getDelegate().writeSInt64NoTag(((AtomicLong)value).longValue());
        }

        @Override
        public OptionalInt size(ImmutableSerializationContext context, Object value) {
            return OptionalInt.of(Predictable.signedLongSize(((AtomicLong)value).longValue()));
        }
    }
    ,
    REFERENCE((Class)AtomicReference.class){
        private final ProtoStreamMarshaller<AtomicReference> marshaller = new FunctionalObjectMarshaller<AtomicReference>(AtomicReference.class, AtomicReference::new, AtomicReference::get);

        @Override
        public ProtoStreamMarshaller<?> getMarshaller() {
            return this.marshaller;
        }
    };

    private final Class<?> targetClass;

    private AtomicMarshaller(Class<?> targetClass) {
        this.targetClass = targetClass;
    }

    @Override
    public Class<? extends Object> getJavaClass() {
        return this.targetClass;
    }

    @Override
    public ProtoStreamMarshaller<?> getMarshaller() {
        return this;
    }
}

