/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.ssl;

import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.util.Collection;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.activemq.artemis.api.core.TrustManagerFactoryPlugin;
import org.apache.activemq.artemis.core.remoting.impl.netty.TransportConstants;
import org.apache.activemq.artemis.utils.ClassloadingUtil;

public class SSLSupport {
    private String keystoreProvider = "JKS";
    private String keystorePath = TransportConstants.DEFAULT_KEYSTORE_PATH;
    private String keystorePassword = TransportConstants.DEFAULT_KEYSTORE_PASSWORD;
    private String truststoreProvider = "JKS";
    private String truststorePath = TransportConstants.DEFAULT_TRUSTSTORE_PATH;
    private String truststorePassword = TransportConstants.DEFAULT_TRUSTSTORE_PASSWORD;
    private String crlPath = TransportConstants.DEFAULT_CRL_PATH;
    private String sslProvider = "JDK";
    private boolean trustAll = false;
    private String trustManagerFactoryPlugin = TransportConstants.DEFAULT_TRUST_MANAGER_FACTORY_PLUGIN;

    public String getKeystoreProvider() {
        return this.keystoreProvider;
    }

    public SSLSupport setKeystoreProvider(String keystoreProvider) {
        this.keystoreProvider = keystoreProvider;
        return this;
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    public SSLSupport setKeystorePath(String keystorePath) {
        this.keystorePath = keystorePath;
        return this;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public SSLSupport setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
        return this;
    }

    public String getTruststoreProvider() {
        return this.truststoreProvider;
    }

    public SSLSupport setTruststoreProvider(String truststoreProvider) {
        this.truststoreProvider = truststoreProvider;
        return this;
    }

    public String getTruststorePath() {
        return this.truststorePath;
    }

    public SSLSupport setTruststorePath(String truststorePath) {
        this.truststorePath = truststorePath;
        return this;
    }

    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    public SSLSupport setTruststorePassword(String truststorePassword) {
        this.truststorePassword = truststorePassword;
        return this;
    }

    public String getCrlPath() {
        return this.crlPath;
    }

    public SSLSupport setCrlPath(String crlPath) {
        this.crlPath = crlPath;
        return this;
    }

    public String getSslProvider() {
        return this.sslProvider;
    }

    public SSLSupport setSslProvider(String sslProvider) {
        this.sslProvider = sslProvider;
        return this;
    }

    public boolean isTrustAll() {
        return this.trustAll;
    }

    public SSLSupport setTrustAll(boolean trustAll) {
        this.trustAll = trustAll;
        return this;
    }

    public String getTrustManagerFactoryPlugin() {
        return this.trustManagerFactoryPlugin;
    }

    public SSLSupport setTrustManagerFactoryPlugin(String trustManagerFactoryPlugin) {
        this.trustManagerFactoryPlugin = trustManagerFactoryPlugin;
        return this;
    }

    public SSLContext createContext() throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        KeyManager[] keyManagers = this.loadKeyManagers();
        TrustManager[] trustManagers = this.loadTrustManagers();
        context.init(keyManagers, trustManagers, new SecureRandom());
        return context;
    }

    public SslContext createNettyContext() throws Exception {
        KeyStore keyStore = SSLSupport.loadKeystore(this.keystoreProvider, this.keystorePath, this.keystorePassword);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, this.keystorePassword.toCharArray());
        return SslContextBuilder.forServer((KeyManagerFactory)keyManagerFactory).sslProvider(SslProvider.valueOf((String)this.sslProvider)).trustManager(this.loadTrustManagerFactory()).build();
    }

    public SslContext createNettyClientContext() throws Exception {
        KeyStore keyStore = SSLSupport.loadKeystore(this.keystoreProvider, this.keystorePath, this.keystorePassword);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, this.keystorePassword == null ? null : this.keystorePassword.toCharArray());
        return SslContextBuilder.forClient().sslProvider(SslProvider.valueOf((String)this.sslProvider)).keyManager(keyManagerFactory).trustManager(this.loadTrustManagerFactory()).build();
    }

    public static String[] parseCommaSeparatedListIntoArray(String suites) {
        String[] cipherSuites = suites.split(",");
        for (int i = 0; i < cipherSuites.length; ++i) {
            cipherSuites[i] = cipherSuites[i].trim();
        }
        return cipherSuites;
    }

    public static String parseArrayIntoCommandSeparatedList(String[] suites) {
        StringBuilder supportedSuites = new StringBuilder();
        for (String suite : suites) {
            supportedSuites.append(suite);
            supportedSuites.append(", ");
        }
        return supportedSuites.delete(supportedSuites.length() - 2, supportedSuites.length()).toString();
    }

    private TrustManagerFactory loadTrustManagerFactory() throws Exception {
        if (this.trustManagerFactoryPlugin != null) {
            return AccessController.doPrivileged(() -> ((TrustManagerFactoryPlugin)ClassloadingUtil.newInstanceFromClassLoader(SSLSupport.class, (String)this.trustManagerFactoryPlugin)).getTrustManagerFactory());
        }
        if (this.trustAll) {
            return InsecureTrustManagerFactory.INSTANCE;
        }
        if (!(this.truststorePath != null || this.truststoreProvider != null && "PKCS11".equals(this.truststoreProvider.toUpperCase()))) {
            return null;
        }
        TrustManagerFactory trustMgrFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        KeyStore trustStore = SSLSupport.loadKeystore(this.truststoreProvider, this.truststorePath, this.truststorePassword);
        boolean ocsp = Boolean.valueOf(Security.getProperty("ocsp.enable"));
        boolean initialized = false;
        if ((ocsp || this.crlPath != null) && TrustManagerFactory.getDefaultAlgorithm().equalsIgnoreCase("PKIX")) {
            PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector());
            if (this.crlPath != null) {
                pkixParams.setRevocationEnabled(true);
                Collection<? extends CRL> crlList = this.loadCRL();
                if (crlList != null) {
                    pkixParams.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(crlList)));
                }
            }
            trustMgrFactory.init(new CertPathTrustManagerParameters(pkixParams));
            initialized = true;
        }
        if (!initialized) {
            trustMgrFactory.init(trustStore);
        }
        return trustMgrFactory;
    }

    private TrustManager[] loadTrustManagers() throws Exception {
        TrustManagerFactory trustManagerFactory = this.loadTrustManagerFactory();
        if (trustManagerFactory == null) {
            return null;
        }
        return trustManagerFactory.getTrustManagers();
    }

    private Collection<? extends CRL> loadCRL() throws Exception {
        if (this.crlPath == null) {
            return null;
        }
        URL resource = SSLSupport.validateStoreURL(this.crlPath);
        try (InputStream is = resource.openStream();){
            Collection<? extends CRL> collection = CertificateFactory.getInstance("X.509").generateCRLs(is);
            return collection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore loadKeystore(String keystoreProvider, String keystorePath, String keystorePassword) throws Exception {
        KeyStore ks = KeyStore.getInstance(keystoreProvider);
        InputStream in = null;
        try {
            if (keystorePath != null) {
                URL keystoreURL = SSLSupport.validateStoreURL(keystorePath);
                in = keystoreURL.openStream();
            }
            ks.load(in, keystorePassword == null ? null : keystorePassword.toCharArray());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return ks;
    }

    private KeyManager[] loadKeyManagers() throws Exception {
        KeyManagerFactory factory = this.loadKeyManagerFactory();
        if (factory == null) {
            return null;
        }
        return factory.getKeyManagers();
    }

    private KeyManagerFactory loadKeyManagerFactory() throws Exception {
        if (!(this.keystorePath != null || this.keystoreProvider != null && "PKCS11".equals(this.keystoreProvider.toUpperCase()))) {
            return null;
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore ks = SSLSupport.loadKeystore(this.keystoreProvider, this.keystorePath, this.keystorePassword);
        kmf.init(ks, this.keystorePassword == null ? null : this.keystorePassword.toCharArray());
        return kmf;
    }

    private static URL validateStoreURL(String storePath) throws Exception {
        assert (storePath != null);
        try {
            return new URL(storePath);
        }
        catch (MalformedURLException e) {
            File file = new File(storePath);
            if (file.exists() && file.isFile()) {
                return file.toURI().toURL();
            }
            URL url = SSLSupport.findResource(storePath);
            if (url != null) {
                return url;
            }
            throw new Exception("Failed to find a store at " + storePath);
        }
    }

    private static URL findResource(final String resourceName) {
        return AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return ClassloadingUtil.findResource((String)resourceName);
            }
        });
    }
}

