/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.converter.jms;

import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSMessage;
import org.apache.qpid.proton.amqp.Binary;

public class ServerJMSObjectMessage
extends ServerJMSMessage
implements ObjectMessage {
    public static final byte TYPE = 2;
    private Binary payload;

    public ServerJMSObjectMessage(ICoreMessage message) {
        super(message);
    }

    public void setObject(Serializable object) throws JMSException {
        throw new UnsupportedOperationException("Cannot set Object on this internal message");
    }

    public Serializable getObject() throws JMSException {
        throw new UnsupportedOperationException("Cannot set Object on this internal message");
    }

    public void setSerializedForm(Binary payload) {
        this.payload = payload;
    }

    public Binary getSerializedForm() {
        return this.payload;
    }

    @Override
    public void encode() throws Exception {
        super.encode();
        this.getInnerMessage().getBodyBuffer().writeInt(this.payload.getLength());
        this.getInnerMessage().getBodyBuffer().writeBytes(this.payload.getArray(), this.payload.getArrayOffset(), this.payload.getLength());
    }

    @Override
    public void decode() throws Exception {
        super.decode();
        ActiveMQBuffer buffer = this.getInnerMessage().getDataBuffer();
        int size = buffer.readInt();
        byte[] bytes = new byte[size];
        buffer.readBytes(bytes);
        this.payload = new Binary(bytes);
    }
}

