/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.impl.ClientStatistics;
import org.infinispan.client.hotrod.impl.DelegatingRemoteCache;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.near.NearCacheService;

public class InvalidatedNearRemoteCache<K, V>
extends DelegatingRemoteCache<K, V> {
    private final NearCacheService<K, V> nearcache;
    private final ClientStatistics clientStatistics;

    InvalidatedNearRemoteCache(InternalRemoteCache<K, V> remoteCache, ClientStatistics clientStatistics, NearCacheService<K, V> nearcache) {
        super(remoteCache);
        this.clientStatistics = clientStatistics;
        this.nearcache = nearcache;
    }

    @Override
    <Key, Value> InternalRemoteCache<Key, Value> newDelegatingCache(InternalRemoteCache<Key, Value> innerCache) {
        return new InvalidatedNearRemoteCache<Key, Value>(innerCache, this.clientStatistics, this.nearcache);
    }

    public static <K, V> InvalidatedNearRemoteCache<K, V> delegatingNearCache(RemoteCacheImpl<K, V> remoteCache, NearCacheService<K, V> nearCacheService) {
        return new InvalidatedNearRemoteCache<K, V>(remoteCache, remoteCache.clientStatistics, nearCacheService);
    }

    @Override
    public CompletableFuture<V> getAsync(Object key) {
        CompletableFuture<MetadataValue<V>> value = this.getWithMetadataAsync(key);
        return value.thenApply(v -> v != null ? v.getValue() : null);
    }

    @Override
    public CompletableFuture<MetadataValue<V>> getWithMetadataAsync(K key) {
        MetadataValue<V> nearValue = this.nearcache.get(key);
        if (nearValue == null) {
            this.clientStatistics.incrementNearCacheMisses();
            CompletableFuture remoteValue = super.getWithMetadataAsync(key);
            return remoteValue.thenApply(v -> {
                if (v != null) {
                    this.nearcache.putIfAbsent(key, (MetadataValue<V>)v);
                    if (v.getMaxIdle() > 0) {
                        Log.HOTROD.nearCacheMaxIdleUnsupported();
                    }
                }
                return v;
            });
        }
        this.clientStatistics.incrementNearCacheHits();
        return CompletableFuture.completedFuture(nearValue);
    }

    @Override
    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        if (maxIdleTime > 0L) {
            Log.HOTROD.nearCacheMaxIdleUnsupported();
        }
        CompletableFuture<V> ret = super.putAsync(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        return ret.thenApply(v -> {
            this.nearcache.remove(key);
            return v;
        });
    }

    @Override
    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        if (maxIdleTime > 0L) {
            Log.HOTROD.nearCacheMaxIdleUnsupported();
        }
        return super.putAllAsync(map, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit).thenRun(() -> map.keySet().forEach(this.nearcache::remove));
    }

    @Override
    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        if (maxIdleTime > 0L) {
            Log.HOTROD.nearCacheMaxIdleUnsupported();
        }
        return this.invalidateNearCacheIfNeeded(this.delegate.hasForceReturnFlag(), key, super.replaceAsync(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit));
    }

    @Override
    public CompletableFuture<Boolean> replaceWithVersionAsync(K key, V newValue, long version, long lifespan, TimeUnit lifespanTimeUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        if (maxIdleTime > 0L) {
            Log.HOTROD.nearCacheMaxIdleUnsupported();
        }
        return super.replaceWithVersionAsync(key, newValue, version, lifespan, lifespanTimeUnit, maxIdleTime, maxIdleTimeUnit).thenApply(removed -> {
            if (removed.booleanValue()) {
                this.nearcache.remove(key);
            }
            return removed;
        });
    }

    @Override
    public CompletableFuture<V> removeAsync(Object key) {
        return this.invalidateNearCacheIfNeeded(this.delegate.hasForceReturnFlag(), key, super.removeAsync(key));
    }

    @Override
    public CompletableFuture<Boolean> removeWithVersionAsync(K key, long version) {
        return super.removeWithVersionAsync(key, version).thenApply(removed -> {
            if (removed.booleanValue()) {
                this.nearcache.remove(key);
            }
            return removed;
        });
    }

    @Override
    public CompletableFuture<Void> clearAsync() {
        return super.clearAsync().thenRun(() -> this.nearcache.clear());
    }

    CompletableFuture<V> invalidateNearCacheIfNeeded(boolean hasForceReturnValue, Object key, CompletableFuture<V> prev) {
        return prev.thenApply(v -> {
            if (!hasForceReturnValue || v != null) {
                this.nearcache.remove(key);
            }
            return v;
        });
    }

    @Override
    public void start() {
        super.start();
        this.nearcache.start(this);
    }

    @Override
    public void stop() {
        this.nearcache.stop(this);
        super.stop();
    }
}

