/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.permission.acl.spi;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.picketlink.idm.permission.acl.spi.PermissionHandler;
import org.picketlink.idm.permission.annotations.AllowedOperation;
import org.picketlink.idm.permission.annotations.AllowedOperations;

public abstract class BaseAbstractPermissionHandler
implements PermissionHandler {
    private Map<Class<?>, Boolean> usesMask = new HashMap();
    private Map<Class<?>, Map<String, Long>> instanceOperations = new ConcurrentHashMap();
    private Map<Class<?>, Map<String, Long>> classOperations = new ConcurrentHashMap();

    private synchronized void initOperations(Class<?> cls) {
        if (!this.instanceOperations.containsKey(cls)) {
            AllowedOperation[] operations;
            HashMap<String, Long> instanceOps = new HashMap<String, Long>();
            HashMap<String, Long> classOps = new HashMap<String, Long>();
            boolean useMask = false;
            AllowedOperations p = cls.getAnnotation(AllowedOperations.class);
            if (p != null && (operations = p.value()) != null) {
                for (AllowedOperation operation : operations) {
                    if (operation.classOperation()) {
                        classOps.put(operation.value(), operation.mask());
                    } else {
                        instanceOps.put(operation.value(), operation.mask());
                    }
                    if (operation.mask() == 0L) continue;
                    useMask = true;
                }
            }
            if (useMask) {
                HashSet<Long> masks = new HashSet<Long>();
                HashSet ops = new HashSet();
                ops.addAll(instanceOps.keySet());
                ops.addAll(classOps.keySet());
                for (String op : ops) {
                    Long mask;
                    Long l = mask = instanceOps.containsKey(op) ? (Long)instanceOps.get(op) : (Long)classOps.get(op);
                    if (masks.contains(mask)) {
                        throw new IllegalArgumentException("Class " + cls.getName() + " defines a duplicate mask for permission operation [" + op + "]");
                    }
                    if (mask == 0L) {
                        throw new IllegalArgumentException("Class " + cls.getName() + " must define a valid mask value for operation [" + op + "]");
                    }
                    if ((mask & mask - 1L) != 0L) {
                        throw new IllegalArgumentException("Class " + cls.getName() + " must define a mask value that is a power of 2 for operation [" + op + "]");
                    }
                    masks.add(mask);
                }
            }
            this.usesMask.put(cls, useMask);
            this.instanceOperations.put(cls, instanceOps);
        }
    }

    public PermissionSet createPermissionSet(Class<?> resourceClass, String members) {
        if (!this.instanceOperations.containsKey(resourceClass)) {
            this.initOperations(resourceClass);
        }
        return new PermissionSet(resourceClass, members);
    }

    @Override
    public Set<String> listClassOperations(Class<?> resourceClass) {
        if (!this.classOperations.containsKey(resourceClass)) {
            this.initOperations(resourceClass);
        }
        HashSet<String> permissions = new HashSet<String>();
        for (String permission : this.classOperations.get(resourceClass).keySet()) {
            permissions.add(permission);
        }
        return permissions;
    }

    @Override
    public Set<String> listInstanceOperations(Class<?> resourceClass) {
        if (!this.instanceOperations.containsKey(resourceClass)) {
            this.initOperations(resourceClass);
        }
        HashSet<String> permissions = new HashSet<String>();
        for (String permission : this.instanceOperations.get(resourceClass).keySet()) {
            permissions.add(permission);
        }
        return permissions;
    }

    protected class PermissionSet {
        private Set<String> permissions = new HashSet<String>();
        private Class<?> resourceClass;

        public PermissionSet(Class<?> resourceClass, String members) {
            this.resourceClass = resourceClass;
            this.addMembers(members);
        }

        public void addMembers(String members) {
            if (members == null) {
                return;
            }
            if (((Boolean)BaseAbstractPermissionHandler.this.usesMask.get(this.resourceClass)).booleanValue()) {
                long vals = Long.valueOf(members);
                Map permissions = (Map)BaseAbstractPermissionHandler.this.instanceOperations.get(this.resourceClass);
                for (String permission : permissions.keySet()) {
                    long mask = (Long)permissions.get(permission);
                    if ((vals & mask) == 0L) continue;
                    this.permissions.add(permission);
                }
            } else {
                String[] permissions;
                for (String permission : permissions = members.split(",")) {
                    this.permissions.add(permission);
                }
            }
        }

        public boolean contains(String action) {
            return this.permissions.contains(action);
        }

        public PermissionSet add(String action) {
            this.permissions.add(action);
            return this;
        }

        public PermissionSet remove(String action) {
            this.permissions.remove(action);
            return this;
        }

        public Set<String> getPermissions() {
            return this.permissions;
        }

        public boolean isEmpty() {
            return this.permissions.isEmpty();
        }

        public String toString() {
            if (((Boolean)BaseAbstractPermissionHandler.this.usesMask.get(this.resourceClass)).booleanValue()) {
                Map actions = (Map)BaseAbstractPermissionHandler.this.instanceOperations.get(this.resourceClass);
                long mask = 0L;
                for (String member : this.permissions) {
                    mask |= ((Long)actions.get(member)).longValue();
                }
                return "" + mask;
            }
            StringBuilder sb = new StringBuilder();
            for (String member : this.permissions) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(member);
            }
            return sb.toString();
        }
    }
}

