/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.ejb3.subsystem.ApplicationSecurityDomainDefinition;
import org.jboss.as.ejb3.subsystem.EJB3Subsystem40Parser;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemNamespace;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemRootResourceDefinition;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemXMLAttribute;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemXMLElement;
import org.jboss.as.ejb3.subsystem.IdentityResourceDefinition;
import org.jboss.as.ejb3.subsystem.RemotingProfileResourceDefinition;
import org.jboss.as.ejb3.subsystem.StaticEJBDiscoveryDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class EJB3Subsystem50Parser
extends EJB3Subsystem40Parser {
    EJB3Subsystem50Parser() {
    }

    @Override
    protected EJB3SubsystemNamespace getExpectedNamespace() {
        return EJB3SubsystemNamespace.EJB3_5_0;
    }

    @Override
    protected void readElement(XMLExtendedStreamReader reader, EJB3SubsystemXMLElement element, List<ModelNode> operations, ModelNode ejb3SubsystemAddOperation) throws XMLStreamException {
        switch (element) {
            case APPLICATION_SECURITY_DOMAINS: {
                this.parseApplicationSecurityDomains(reader, operations);
                break;
            }
            case IDENTITY: {
                this.parseIdentity(reader, operations);
                break;
            }
            case ALLOW_EJB_NAME_REGEX: {
                this.parseAllowEjbNameRegex(reader, ejb3SubsystemAddOperation);
                break;
            }
            case ENABLE_GRACEFUL_TXN_SHUTDOWN: {
                this.parseEnableGracefulTxnShutdown(reader, ejb3SubsystemAddOperation);
                break;
            }
            default: {
                super.readElement(reader, element, operations, ejb3SubsystemAddOperation);
            }
        }
    }

    private void parseApplicationSecurityDomains(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        boolean applicationSecurityDomainFound = false;
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case APPLICATION_SECURITY_DOMAIN: {
                    this.parseApplicationSecurityDomain(reader, operations);
                    applicationSecurityDomainFound = true;
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!applicationSecurityDomainFound) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, Collections.singleton(EJB3SubsystemXMLElement.APPLICATION_SECURITY_DOMAIN.getLocalName()));
        }
    }

    private void parseApplicationSecurityDomain(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        String applicationSecurityDomain = null;
        ModelNode operation = Util.createAddOperation();
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String attributeValue = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    applicationSecurityDomain = attributeValue;
                    continue block5;
                }
                case SECURITY_DOMAIN: {
                    ApplicationSecurityDomainDefinition.SECURITY_DOMAIN.parseAndSetParameter(attributeValue, operation, (XMLStreamReader)reader);
                    continue block5;
                }
                case ENABLE_JACC: {
                    ApplicationSecurityDomainDefinition.ENABLE_JACC.parseAndSetParameter(attributeValue, operation, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (applicationSecurityDomain == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(EJB3SubsystemXMLAttribute.NAME.getLocalName()));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        PathAddress address = this.getEJB3SubsystemAddress().append(new PathElement[]{PathElement.pathElement((String)"application-security-domain", applicationSecurityDomain)});
        operation.get("address").set(address.toModelNode());
        operations.add(operation);
    }

    private void parseAllowEjbNameRegex(XMLExtendedStreamReader reader, ModelNode ejb3SubsystemAddOperation) throws XMLStreamException {
        int count = reader.getAttributeCount();
        EnumSet<EJB3SubsystemXMLAttribute> missingRequiredAttributes = EnumSet.of(EJB3SubsystemXMLAttribute.VALUE);
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case VALUE: {
                    EJB3SubsystemRootResourceDefinition.ALLOW_EJB_NAME_REGEX.parseAndSetParameter(value, ejb3SubsystemAddOperation, (XMLStreamReader)reader);
                    missingRequiredAttributes.remove((Object)EJB3SubsystemXMLAttribute.VALUE);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (!missingRequiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, missingRequiredAttributes);
        }
    }

    private void parseIdentity(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        PathAddress address = this.getEJB3SubsystemAddress().append("service", "identity");
        ModelNode addIdentity = Util.createAddOperation((PathAddress)address);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case OUTFLOW_SECURITY_DOMAINS: {
                    for (String outflowDomain : reader.getListAttributeValue(i)) {
                        IdentityResourceDefinition.OUTFLOW_SECURITY_DOMAINS.parseAndAddParameterElement(outflowDomain, addIdentity, (XMLStreamReader)reader);
                    }
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(addIdentity);
    }

    private void parseEnableGracefulTxnShutdown(XMLExtendedStreamReader reader, ModelNode ejb3SubsystemAddOperation) throws XMLStreamException {
        int count = reader.getAttributeCount();
        EnumSet<EJB3SubsystemXMLAttribute> missingRequiredAttributes = EnumSet.of(EJB3SubsystemXMLAttribute.VALUE);
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case VALUE: {
                    EJB3SubsystemRootResourceDefinition.ENABLE_GRACEFUL_TXN_SHUTDOWN.parseAndSetParameter(value, ejb3SubsystemAddOperation, (XMLStreamReader)reader);
                    missingRequiredAttributes.remove((Object)EJB3SubsystemXMLAttribute.VALUE);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (!missingRequiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, missingRequiredAttributes);
        }
    }

    @Override
    protected void parseProfile(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String profileName = null;
        EJBClientContext.Builder builder = new EJBClientContext.Builder();
        ModelNode operation = Util.createAddOperation();
        block9: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    profileName = value;
                    continue block9;
                }
                case EXCLUDE_LOCAL_RECEIVER: {
                    RemotingProfileResourceDefinition.EXCLUDE_LOCAL_RECEIVER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block9;
                }
                case LOCAL_RECEIVER_PASS_BY_VALUE: {
                    RemotingProfileResourceDefinition.LOCAL_RECEIVER_PASS_BY_VALUE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (profileName == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(EJB3SubsystemXMLAttribute.NAME.getLocalName()));
        }
        PathAddress address = SUBSYSTEM_PATH.append("remoting-profile", profileName);
        operation.get("address").set(address.toModelNode());
        operations.add(operation);
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case STATIC_EJB_DISCOVERY: {
                    ModelNode staticEjb = this.parseStaticEjbDiscoveryType(reader);
                    operation.get("static-ejb-discovery").set(staticEjb);
                    continue block10;
                }
                case REMOTING_EJB_RECEIVER: {
                    this.parseRemotingReceiver(reader, address, operations);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    protected ModelNode parseStaticEjbDiscoveryType(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode staticDiscovery = new ModelNode();
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case MODULE: {
                    ModelNode ejb = new ModelNode();
                    int count = reader.getAttributeCount();
                    String uri = null;
                    String module = null;
                    String app = null;
                    String distinct = null;
                    block10: for (int i = 0; i < count; ++i) {
                        ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                        String value = reader.getAttributeValue(i);
                        EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case URI: {
                                if (uri != null) {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                                uri = value;
                                StaticEJBDiscoveryDefinition.URI_AD.parseAndSetParameter(uri, ejb, (XMLStreamReader)reader);
                                continue block10;
                            }
                            case MODULE_NAME: {
                                if (module != null) {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                                module = value;
                                StaticEJBDiscoveryDefinition.MODULE_AD.parseAndSetParameter(module, ejb, (XMLStreamReader)reader);
                                continue block10;
                            }
                            case APP_NAME: {
                                if (app != null) {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                                app = value;
                                StaticEJBDiscoveryDefinition.APP_AD.parseAndSetParameter(app, ejb, (XMLStreamReader)reader);
                                continue block10;
                            }
                            case DISTINCT_NAME: {
                                if (distinct != null) {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                                distinct = value;
                                StaticEJBDiscoveryDefinition.DISTINCT_AD.parseAndSetParameter(distinct, ejb, (XMLStreamReader)reader);
                                continue block10;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                            }
                        }
                    }
                    if (module == null) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(EJB3SubsystemXMLAttribute.MODULE_NAME.getLocalName()));
                    }
                    if (uri == null) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("uri"));
                    }
                    staticDiscovery.add(ejb);
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return staticDiscovery;
    }
}

