/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application.jsp;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.jstl.core.Config;
import org.apache.myfaces.application.jsp.ServletViewResponseWrapper;
import org.apache.myfaces.shared.application.DefaultViewHandlerSupport;
import org.apache.myfaces.shared.application.InvalidViewIdException;
import org.apache.myfaces.shared.application.ViewHandlerSupport;
import org.apache.myfaces.shared.config.MyfacesConfig;
import org.apache.myfaces.shared.renderkit.html.util.JavascriptUtils;

public class JspViewHandlerImpl
extends ViewHandler {
    private static final Logger log = Logger.getLogger(JspViewHandlerImpl.class.getName());
    public static final String FORM_STATE_MARKER = "<!--@@JSF_FORM_STATE_MARKER@@-->";
    public static final int FORM_STATE_MARKER_LEN = "<!--@@JSF_FORM_STATE_MARKER@@-->".length();
    private static final String AFTER_VIEW_TAG_CONTENT_PARAM = JspViewHandlerImpl.class + ".AFTER_VIEW_TAG_CONTENT";
    private ViewHandlerSupport _viewHandlerSupport;

    public JspViewHandlerImpl() {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("New ViewHandler instance created");
        }
    }

    public void setViewHandlerSupport(ViewHandlerSupport viewHandlerSupport) {
        this._viewHandlerSupport = viewHandlerSupport;
    }

    protected ViewHandlerSupport getViewHandlerSupport() {
        if (this._viewHandlerSupport == null) {
            this._viewHandlerSupport = new DefaultViewHandlerSupport();
        }
        return this._viewHandlerSupport;
    }

    public Locale calculateLocale(FacesContext facesContext) {
        Application application = facesContext.getApplication();
        Iterator requestLocales = facesContext.getExternalContext().getRequestLocales();
        while (requestLocales.hasNext()) {
            Locale requestLocale = (Locale)requestLocales.next();
            Iterator supportedLocales = application.getSupportedLocales();
            while (supportedLocales.hasNext()) {
                Locale supportedLocale = (Locale)supportedLocales.next();
                if (requestLocale.getLanguage().equals(supportedLocale.getLanguage()) && (supportedLocale.getCountry() == null || supportedLocale.getCountry().length() == 0)) {
                    return supportedLocale;
                }
                if (!supportedLocale.equals(requestLocale)) continue;
                return supportedLocale;
            }
        }
        Locale defaultLocale = application.getDefaultLocale();
        return defaultLocale != null ? defaultLocale : Locale.getDefault();
    }

    public String calculateRenderKitId(FacesContext facesContext) {
        Object renderKitId = facesContext.getExternalContext().getRequestMap().get("javax.faces.RenderKitId");
        if (renderKitId == null) {
            renderKitId = facesContext.getApplication().getDefaultRenderKitId();
        }
        if (renderKitId == null) {
            renderKitId = "HTML_BASIC";
        }
        return renderKitId.toString();
    }

    public UIViewRoot createView(FacesContext facesContext, String viewId) {
        String calculatedViewId = viewId;
        try {
            calculatedViewId = this.getViewHandlerSupport().calculateViewId(facesContext, viewId);
        }
        catch (InvalidViewIdException e) {
            this.sendSourceNotFound(facesContext, e.getMessage());
        }
        Application application = facesContext.getApplication();
        ViewHandler applicationViewHandler = application.getViewHandler();
        Locale currentLocale = null;
        String currentRenderKitId = null;
        UIViewRoot uiViewRoot = facesContext.getViewRoot();
        if (uiViewRoot != null) {
            currentLocale = uiViewRoot.getLocale();
            currentRenderKitId = uiViewRoot.getRenderKitId();
        }
        uiViewRoot = (UIViewRoot)application.createComponent("javax.faces.ViewRoot");
        uiViewRoot.setViewId(calculatedViewId);
        if (currentLocale != null) {
            uiViewRoot.setLocale(currentLocale);
        } else {
            uiViewRoot.setLocale(applicationViewHandler.calculateLocale(facesContext));
        }
        if (currentRenderKitId != null) {
            uiViewRoot.setRenderKitId(currentRenderKitId);
        } else {
            uiViewRoot.setRenderKitId(applicationViewHandler.calculateRenderKitId(facesContext));
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Created view " + viewId);
        }
        return uiViewRoot;
    }

    private void sendSourceNotFound(FacesContext context, String message) {
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        try {
            context.responseComplete();
            response.sendError(404, message);
        }
        catch (IOException ioe) {
            throw new FacesException((Throwable)ioe);
        }
    }

    public String getActionURL(FacesContext facesContext, String viewId) {
        return this.getViewHandlerSupport().calculateActionURL(facesContext, viewId);
    }

    public String getResourceURL(FacesContext facesContext, String path) {
        if (path.length() > 0 && path.charAt(0) == '/') {
            String contextPath = facesContext.getExternalContext().getRequestContextPath();
            if (contextPath == null) {
                return path;
            }
            if (contextPath.length() == 1 && contextPath.charAt(0) == '/') {
                return path;
            }
            return contextPath + path;
        }
        return path;
    }

    public void renderView(FacesContext facesContext, UIViewRoot viewToRender) throws IOException, FacesException {
        HttpServletRequest httpServletRequest;
        HttpSession session;
        if (viewToRender == null) {
            log.severe("viewToRender must not be null");
            throw new NullPointerException("viewToRender must not be null");
        }
        if (!viewToRender.isRendered()) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("View is not rendered");
            }
            return;
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        String viewId = facesContext.getViewRoot().getViewId();
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Rendering JSP view: " + viewId);
        }
        ServletResponse response = (ServletResponse)externalContext.getResponse();
        ServletRequest request = (ServletRequest)externalContext.getRequest();
        Locale locale = viewToRender.getLocale();
        response.setLocale(locale);
        Config.set((ServletRequest)request, (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)facesContext.getViewRoot().getLocale());
        if (!this.buildView(response, externalContext, viewId)) {
            return;
        }
        if (externalContext.getRequest() instanceof HttpServletRequest && (session = (httpServletRequest = (HttpServletRequest)externalContext.getRequest()).getSession(false)) != null) {
            session.setAttribute("javax.faces.request.charset", (Object)response.getCharacterEncoding());
        }
        RenderKitFactory renderFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        RenderKit renderKit = renderFactory.getRenderKit(facesContext, viewToRender.getRenderKitId());
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        if (responseWriter == null) {
            responseWriter = renderKit.createResponseWriter((Writer)response.getWriter(), null, ((HttpServletRequest)externalContext.getRequest()).getCharacterEncoding());
            facesContext.setResponseWriter(responseWriter);
        }
        ResponseWriter oldResponseWriter = responseWriter;
        StateMarkerAwareWriter stateAwareWriter = null;
        StateManager stateManager = facesContext.getApplication().getStateManager();
        if (stateManager.isSavingStateInClient(facesContext)) {
            stateAwareWriter = new StateMarkerAwareWriter();
            responseWriter = this.hookInStateAwareWriter(oldResponseWriter, stateAwareWriter, renderKit, externalContext);
            facesContext.setResponseWriter(responseWriter);
        }
        this.actuallyRenderView(facesContext, viewToRender);
        facesContext.setResponseWriter(oldResponseWriter);
        if (stateManager.isSavingStateInClient(facesContext)) {
            stateAwareWriter.flushToWriter(response.getWriter());
        } else {
            stateManager.saveView(facesContext);
        }
        ServletViewResponseWrapper afterViewTagResponse = (ServletViewResponseWrapper)externalContext.getRequestMap().get(AFTER_VIEW_TAG_CONTENT_PARAM);
        externalContext.getRequestMap().remove(AFTER_VIEW_TAG_CONTENT_PARAM);
        if (afterViewTagResponse != null) {
            afterViewTagResponse.flushToWriter(response.getWriter(), facesContext.getExternalContext().getResponseCharacterEncoding());
        }
        response.flushBuffer();
    }

    private void actuallyRenderView(FacesContext facesContext, UIViewRoot viewToRender) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.startDocument();
        viewToRender.encodeAll(facesContext);
        responseWriter.endDocument();
        responseWriter.flush();
    }

    private ResponseWriter hookInStateAwareWriter(ResponseWriter oldResponseWriter, StateMarkerAwareWriter stateAwareWriter, RenderKit renderKit, ExternalContext externalContext) {
        return oldResponseWriter.cloneWithWriter((Writer)stateAwareWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean buildView(ServletResponse response, ExternalContext externalContext, String viewId) throws IOException {
        boolean errorResponse;
        ServletViewResponseWrapper wrappedResponse = new ServletViewResponseWrapper((HttpServletResponse)response);
        externalContext.setResponse((Object)wrappedResponse);
        try {
            externalContext.dispatch(viewId);
        }
        finally {
            externalContext.setResponse((Object)response);
        }
        boolean bl = errorResponse = wrappedResponse.getStatus() < 200 || wrappedResponse.getStatus() > 299;
        if (errorResponse) {
            wrappedResponse.flushToWrappedResponse();
            return false;
        }
        externalContext.getRequestMap().put(AFTER_VIEW_TAG_CONTENT_PARAM, wrappedResponse);
        return true;
    }

    public UIViewRoot restoreView(FacesContext facesContext, String viewId) {
        Application application = facesContext.getApplication();
        ViewHandler applicationViewHandler = application.getViewHandler();
        String renderKitId = applicationViewHandler.calculateRenderKitId(facesContext);
        String calculatedViewId = this.getViewHandlerSupport().calculateViewId(facesContext, viewId);
        UIViewRoot viewRoot = application.getStateManager().restoreView(facesContext, calculatedViewId, renderKitId);
        return viewRoot;
    }

    public void writeState(FacesContext facesContext) throws IOException {
        StateManager stateManager = facesContext.getApplication().getStateManager();
        if (stateManager.isSavingStateInClient(facesContext)) {
            ExternalContext extContext = facesContext.getExternalContext();
            if (!JavascriptUtils.isJavascriptAllowed(extContext) || !MyfacesConfig.getCurrentInstance(extContext).isViewStateJavascript()) {
                facesContext.getResponseWriter().write(FORM_STATE_MARKER);
            }
        } else {
            stateManager.writeState(facesContext, (Object)new Object[2]);
        }
    }

    private static class StateMarkerAwareWriter
    extends Writer {
        private StringBuilder buf = new StringBuilder();

        public void close() throws IOException {
        }

        public void flush() throws IOException {
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            this.buf.append(cbuf, off, len);
        }

        public StringBuilder getStringBuilder() {
            return this.buf;
        }

        public void flushToWriter(Writer writer) throws IOException {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            StateManager stateManager = facesContext.getApplication().getStateManager();
            StringWriter stateWriter = new StringWriter();
            ResponseWriter realWriter = facesContext.getResponseWriter();
            facesContext.setResponseWriter(realWriter.cloneWithWriter((Writer)stateWriter));
            Object serializedView = stateManager.saveView(facesContext);
            stateManager.writeState(facesContext, serializedView);
            facesContext.setResponseWriter(realWriter);
            StringBuilder contentBuffer = this.getStringBuilder();
            String state = stateWriter.getBuffer().toString();
            ExternalContext extContext = facesContext.getExternalContext();
            if (JavascriptUtils.isJavascriptAllowed(extContext) && MyfacesConfig.getCurrentInstance(extContext).isViewStateJavascript()) {
                this.write(contentBuffer, 0, contentBuffer.length(), writer);
                writer.write(state);
            } else {
                int lastFormMarkerPos = 0;
                int formMarkerPos = 0;
                while ((formMarkerPos = contentBuffer.indexOf(JspViewHandlerImpl.FORM_STATE_MARKER, formMarkerPos)) > -1) {
                    this.write(contentBuffer, lastFormMarkerPos, formMarkerPos, writer);
                    writer.write(state);
                    lastFormMarkerPos = formMarkerPos += FORM_STATE_MARKER_LEN;
                }
                if (lastFormMarkerPos < contentBuffer.length()) {
                    this.write(contentBuffer, lastFormMarkerPos, contentBuffer.length(), writer);
                }
            }
        }

        private void write(StringBuilder contentBuffer, int beginIndex, int endIndex, Writer writer) throws IOException {
            int bufferSize = 2048;
            char[] bufToWrite = new char[bufferSize];
            for (int index = beginIndex; index < endIndex; index += bufferSize) {
                int maxSize = Math.min(bufferSize, endIndex - index);
                contentBuffer.getChars(index, index + maxSize, bufToWrite, 0);
                writer.write(bufToWrite, 0, maxSize);
            }
        }
    }
}

