/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl.jdbc;

import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.server.ActiveMQScheduledComponent;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.impl.jdbc.LeaseLock;
import org.apache.activemq.artemis.core.server.impl.jdbc.ScheduledLeaseLock;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;
import org.jboss.logging.Logger;

final class ActiveMQScheduledLeaseLock
extends ActiveMQScheduledComponent
implements ScheduledLeaseLock {
    private static final Logger LOGGER = Logger.getLogger(ActiveMQScheduledLeaseLock.class);
    private final String lockName;
    private final LeaseLock lock;
    private long lastLockRenewStart;
    private final long renewPeriodMillis;
    private final NodeManager.LockListener lockListener;

    ActiveMQScheduledLeaseLock(ScheduledExecutorService scheduledExecutorService, ArtemisExecutor executor, String lockName, LeaseLock lock, long renewPeriodMillis, NodeManager.LockListener lockListener) {
        super(scheduledExecutorService, (Executor)executor, 0L, renewPeriodMillis, TimeUnit.MILLISECONDS, false);
        if (renewPeriodMillis >= lock.expirationMillis()) {
            throw new IllegalArgumentException("renewPeriodMillis must be < lock's expirationMillis");
        }
        this.lockName = lockName;
        this.lock = lock;
        this.renewPeriodMillis = renewPeriodMillis;
        this.lastLockRenewStart = System.nanoTime() - TimeUnit.MILLISECONDS.toNanos(lock.expirationMillis());
        this.lockListener = lockListener;
    }

    @Override
    public String lockName() {
        return this.lockName;
    }

    @Override
    public long renewPeriodMillis() {
        return this.renewPeriodMillis;
    }

    @Override
    public LeaseLock lock() {
        return this.lock;
    }

    @Override
    public synchronized void start() {
        if (this.isStarted()) {
            return;
        }
        this.lastLockRenewStart = System.nanoTime();
        super.start();
    }

    @Override
    public synchronized void stop() {
        if (!this.isStarted()) {
            return;
        }
        super.stop();
    }

    public synchronized void run() {
        boolean lockLost;
        long renewStart;
        long lastRenewStart;
        block6: {
            if (!this.isStarted()) {
                return;
            }
            lastRenewStart = this.lastLockRenewStart;
            renewStart = System.nanoTime();
            lockLost = true;
            try {
                lockLost = !this.lock.renew();
            }
            catch (Throwable t) {
                long millisBeforeExpiration;
                LOGGER.warnf(t, "%s lock renew has failed", (Object)this.lockName);
                if (this.lock.localExpirationTime() <= 0L || (millisBeforeExpiration = this.lock.localExpirationTime() - System.currentTimeMillis()) < this.renewPeriodMillis) break block6;
                lockLost = false;
            }
        }
        if (lockLost) {
            try {
                this.lockListener.lostLock();
            }
            catch (Throwable t) {
                LOGGER.warnf(t, "Errored while notifying %s lock listener", (Object)this.lockName);
            }
        }
        ActiveMQScheduledLeaseLock.detectAndReportRenewSlowness(this.lockName, lockLost, lastRenewStart, renewStart, this.renewPeriodMillis, this.lock.expirationMillis());
        this.lastLockRenewStart = renewStart;
    }

    private static void detectAndReportRenewSlowness(String lockName, boolean lostLock, long lastRenewStart, long renewStart, long expectedRenewPeriodMillis, long expirationMillis) {
        long measuredRenewPeriodNanos;
        long measuredRenewPeriodMillis;
        long elapsedMillisToRenew = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - renewStart);
        if (elapsedMillisToRenew > expectedRenewPeriodMillis) {
            LOGGER.errorf("%s lock %s renew tooks %d ms, while is supposed to take <%d ms", new Object[]{lockName, lostLock ? "failed" : "successful", elapsedMillisToRenew, expectedRenewPeriodMillis});
        }
        if ((measuredRenewPeriodMillis = TimeUnit.NANOSECONDS.toMillis(measuredRenewPeriodNanos = renewStart - lastRenewStart)) - expirationMillis > 100L) {
            LOGGER.errorf("%s lock %s renew period lasted %d ms instead of %d ms", new Object[]{lockName, lostLock ? "failed" : "successful", measuredRenewPeriodMillis, expectedRenewPeriodMillis});
        } else if (measuredRenewPeriodMillis - expectedRenewPeriodMillis > 100L) {
            LOGGER.warnf("%s lock %s renew period lasted %d ms instead of %d ms", new Object[]{lockName, lostLock ? "failed" : "successful", measuredRenewPeriodMillis, expectedRenewPeriodMillis});
        }
    }
}

