/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.impl;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import org.wildfly.common.bytes.ByteStringBuilder;

class DigestUtil {
    DigestUtil() {
    }

    public static byte[] userRealmPasswordDigest(MessageDigest messageDigest, String username, String realm, char[] password) {
        CharsetEncoder latin1Encoder = StandardCharsets.ISO_8859_1.newEncoder();
        latin1Encoder.reset();
        boolean bothLatin1 = latin1Encoder.canEncode(username);
        latin1Encoder.reset();
        if (bothLatin1) {
            for (char c : password) {
                bothLatin1 = bothLatin1 && latin1Encoder.canEncode(c);
            }
        }
        Charset chosenCharset = StandardCharsets.UTF_8;
        ByteStringBuilder urp = new ByteStringBuilder();
        urp.append(username.getBytes(chosenCharset));
        urp.append(':');
        if (realm != null) {
            urp.append(realm.getBytes(chosenCharset));
        } else {
            urp.append("");
        }
        urp.append(':');
        urp.append(new String(password).getBytes(chosenCharset));
        return messageDigest.digest(urp.toArray());
    }
}

