/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.RunAs;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextFactory;
import org.jboss.security.SecurityContextUtil;
import org.jboss.security.SecurityManagerLocator;
import org.jboss.security.SubjectInfo;
import org.jboss.security.audit.AuditManager;
import org.jboss.security.auth.callback.JBossCallbackHandler;
import org.jboss.security.identitytrust.IdentityTrustManager;
import org.jboss.security.mapping.MappingManager;
import org.jboss.security.plugins.DefaultSecurityManagement;

public class JBossSecurityContext
implements SecurityContext,
SecurityManagerLocator {
    private static final long serialVersionUID = 1L;
    private static final RuntimePermission getDataPermission = new RuntimePermission(JBossSecurityContext.class.getName() + ".getData");
    private static final RuntimePermission getSubjectInfoPermission = new RuntimePermission(JBossSecurityContext.class.getName() + ".getSubjectInfo");
    private static final RuntimePermission setRolesPermission = new RuntimePermission(JBossSecurityContext.class.getName() + ".setRolesPermission");
    private static final RuntimePermission setRunAsPermission = new RuntimePermission(JBossSecurityContext.class.getName() + ".setRunAsPermission");
    private static final RuntimePermission setSubjectInfoPermission = new RuntimePermission(JBossSecurityContext.class.getName() + ".setSubjectInfo");
    private static final RuntimePermission getSecurityManagementPermission = new RuntimePermission(JBossSecurityContext.class.getName() + ".getSecurityManagement");
    private static final RuntimePermission setSecurityManagementPermission = new RuntimePermission(JBossSecurityContext.class.getName() + ".setSecurityManagement");
    private static final RuntimePermission setSecurityDomainPermission = new RuntimePermission(JBossSecurityContext.class.getName() + ".setSecurityDomain");
    protected static final Logger log = Logger.getLogger(JBossSecurityContext.class);
    protected boolean trace = log.isTraceEnabled();
    protected Map<String, Object> contextData = new HashMap<String, Object>();
    protected String securityDomain = "other";
    protected SubjectInfo subjectInfo = null;
    protected RunAs incomingRunAs = null;
    protected RunAs outgoingRunAs = null;
    protected ISecurityManagement iSecurityManagement;
    protected transient CallbackHandler callbackHandler = new JBossCallbackHandler();
    protected transient SecurityContextUtil util = null;

    public JBossSecurityContext(String securityDomain) {
        this.securityDomain = securityDomain;
        if (this.callbackHandler == null) {
            this.callbackHandler = new JBossCallbackHandler();
        }
        this.iSecurityManagement = new DefaultSecurityManagement(this.callbackHandler);
        this.util = this.getUtil();
        this.util.createSubjectInfo(null, null, null);
    }

    @Override
    public ISecurityManagement getSecurityManagement() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(getSecurityManagementPermission);
        }
        return this.iSecurityManagement;
    }

    @Override
    public void setSecurityManagement(ISecurityManagement securityManagement) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setSecurityManagementPermission);
        }
        if (securityManagement == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("securityManagement");
        }
        this.iSecurityManagement = securityManagement;
    }

    @Override
    public Map<String, Object> getData() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(getDataPermission);
        }
        return this.contextData;
    }

    @Override
    public String getSecurityDomain() {
        return this.securityDomain;
    }

    @Override
    public void setSecurityDomain(String securityDomain) {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkPermission(setSecurityDomainPermission);
        }
        if (securityDomain == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("securityDomain");
        }
        this.securityDomain = securityDomain;
    }

    @Override
    public SubjectInfo getSubjectInfo() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(getSubjectInfoPermission);
        }
        return this.subjectInfo;
    }

    @Override
    public RunAs getIncomingRunAs() {
        return this.incomingRunAs;
    }

    @Override
    public void setIncomingRunAs(RunAs runAs) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setRunAsPermission);
        }
        this.incomingRunAs = runAs;
    }

    @Override
    public RunAs getOutgoingRunAs() {
        return this.outgoingRunAs;
    }

    @Override
    public void setOutgoingRunAs(RunAs runAs) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setRunAsPermission);
        }
        this.outgoingRunAs = runAs;
    }

    @Override
    public SecurityContextUtil getUtil() {
        if (this.util == null) {
            try {
                this.util = SecurityContextFactory.createUtil(this);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return this.util;
    }

    @Override
    public AuditManager getAuditManager() {
        return this.iSecurityManagement.getAuditManager(this.securityDomain);
    }

    @Override
    public AuthenticationManager getAuthenticationManager() {
        return this.iSecurityManagement.getAuthenticationManager(this.securityDomain);
    }

    @Override
    public AuthorizationManager getAuthorizationManager() {
        return this.iSecurityManagement.getAuthorizationManager(this.securityDomain);
    }

    @Override
    public IdentityTrustManager getIdentityTrustManager() {
        return this.iSecurityManagement.getIdentityTrustManager(this.securityDomain);
    }

    @Override
    public MappingManager getMappingManager() {
        return this.iSecurityManagement.getMappingManager(this.securityDomain);
    }

    @Override
    public void setSubjectInfo(SubjectInfo si) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setSubjectInfoPermission);
        }
        this.subjectInfo = si;
    }

    public void setRoles(Group roles, boolean replace) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setRolesPermission);
        }
        Group mergedRoles = roles;
        if (!replace) {
            mergedRoles = this.mergeGroups((Group)this.contextData.get("Roles"), roles);
        }
        this.contextData.put("Roles", mergedRoles);
    }

    private Group mergeGroups(Group a, Group b) {
        Group newGroup = b;
        if (a != null) {
            Enumeration en = a.members();
            while (en.hasMoreElements()) {
                newGroup.addMember((Principal)en.nextElement());
            }
        }
        return newGroup;
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[").append(this.getClass().getCanonicalName()).append("()");
        builder.append(this.securityDomain).append(")]");
        return builder.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        JBossSecurityContext jsc = (JBossSecurityContext)super.clone();
        if (jsc != null) {
            HashMap cmap = (HashMap)this.contextData;
            jsc.contextData = (Map)cmap.clone();
        }
        return jsc;
    }
}

