/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron.expression;

import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.Map;
import javax.crypto.SecretKey;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.wildfly.common.Assert;
import org.wildfly.common.function.ExceptionBiConsumer;
import org.wildfly.common.function.ExceptionFunction;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.credential.SecretKeyCredential;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.encryption.CipherUtil;

public class ElytronExpressionResolver
implements ExpressionResolver {
    private static final String CREDENTIAL_STORE_API_CAPABILITY = "org.wildfly.security.credential-store-api";
    private volatile boolean initialised = false;
    private final ThreadLocal<String> initialisingFor = new ThreadLocal();
    private volatile OperationFailedException firstFailure = null;
    private final ExceptionBiConsumer<ElytronExpressionResolver, OperationContext, OperationFailedException> configurator;
    private volatile String prefix;
    private volatile String completePrefix;
    private volatile String defaultResolver;
    private volatile Map<String, ResolverConfiguration> resolverConfigurations;

    public ElytronExpressionResolver(ExceptionBiConsumer<ElytronExpressionResolver, OperationContext, OperationFailedException> configurator) {
        this.configurator = configurator;
    }

    public ModelNode resolveExpressions(ModelNode node) throws OperationFailedException {
        return this.resolveExpressions(node, null);
    }

    public ModelNode resolveExpressions(ModelNode node, OperationContext context) throws OperationFailedException {
        Assert.checkNotNullParam((String)"context", (Object)context);
        String fullExpression = node.asString();
        if (fullExpression.length() > 3) {
            String expression = fullExpression.substring(2, fullExpression.length() - 1);
            this.ensureInitialised(fullExpression, context);
            if (expression.startsWith(this.completePrefix)) {
                SecretKey secretKey;
                String resolver;
                int delimiter = expression.indexOf(58, this.completePrefix.length());
                String string = resolver = delimiter > 0 ? expression.substring(this.completePrefix.length(), delimiter) : this.defaultResolver;
                if (resolver == null) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.expressionResolutionWithoutResolver(fullExpression);
                }
                ResolverConfiguration resolverConfiguration = this.resolverConfigurations.get(resolver);
                if (resolverConfiguration == null) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.invalidResolver(fullExpression);
                }
                ElytronSubsystemMessages.ROOT_LOGGER.tracef("Attemting to decrypt expression '%s' using credential store '%s' and alias '%s'.", fullExpression, resolverConfiguration.credentialStore, resolverConfiguration.alias);
                ExceptionFunction credentialStoreApi = (ExceptionFunction)context.getCapabilityRuntimeAPI(CREDENTIAL_STORE_API_CAPABILITY, resolverConfiguration.getCredentialStore(), ExceptionFunction.class);
                CredentialStore credentialStore = (CredentialStore)credentialStoreApi.apply((Object)context);
                try {
                    SecretKeyCredential credential = (SecretKeyCredential)credentialStore.retrieve(resolverConfiguration.getAlias(), SecretKeyCredential.class);
                    secretKey = credential.getSecretKey();
                }
                catch (CredentialStoreException e) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.unableToLoadCredential(e);
                }
                String token = expression.substring(expression.lastIndexOf(58) + 1);
                try {
                    String clearText = CipherUtil.decrypt((String)token, (SecretKey)secretKey);
                    return new ModelNode(clearText);
                }
                catch (GeneralSecurityException e) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.unableToDecyptExpression(fullExpression, e);
                }
            }
        }
        return null;
    }

    public String createExpression(String resolver, String clearText, OperationContext context) throws OperationFailedException {
        String cipherTextToken;
        SecretKey secretKey;
        String resolvedResolver;
        this.ensureInitialised(null, context);
        String string = resolvedResolver = resolver != null ? resolver : this.defaultResolver;
        if (resolvedResolver == null) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.noResolverSpecifiedAndNoDefault();
        }
        ResolverConfiguration resolverConfiguration = this.resolverConfigurations.get(resolvedResolver);
        if (resolverConfiguration == null) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.noResolverWithSpecifiedName(resolvedResolver);
        }
        ExceptionFunction credentialStoreApi = (ExceptionFunction)context.getCapabilityRuntimeAPI(CREDENTIAL_STORE_API_CAPABILITY, resolverConfiguration.getCredentialStore(), ExceptionFunction.class);
        CredentialStore credentialStore = (CredentialStore)credentialStoreApi.apply((Object)context);
        try {
            SecretKeyCredential credential = (SecretKeyCredential)credentialStore.retrieve(resolverConfiguration.getAlias(), SecretKeyCredential.class);
            if (credential == null) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.credentialDoesNotExist(resolverConfiguration.getAlias(), SecretKeyCredential.class.getSimpleName());
            }
            secretKey = credential.getSecretKey();
        }
        catch (CredentialStoreException e) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToLoadCredential(e);
        }
        try {
            cipherTextToken = CipherUtil.encrypt((String)clearText, (SecretKey)secretKey);
        }
        catch (GeneralSecurityException e) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToEncryptClearText(e);
        }
        String expression = resolver == null ? String.format("${%s::%s}", this.prefix, cipherTextToken) : String.format("${%s::%s:%s}", this.prefix, resolvedResolver, cipherTextToken);
        return expression;
    }

    public ElytronExpressionResolver setPrefix(String prefix) {
        this.prefix = prefix;
        this.completePrefix = prefix + "::";
        return this;
    }

    public ElytronExpressionResolver setDefaultResolver(String defaultResolver) {
        this.defaultResolver = defaultResolver;
        return this;
    }

    public ElytronExpressionResolver setResolverConfigurations(Map<String, ResolverConfiguration> resolverConfigurations) {
        this.resolverConfigurations = Collections.unmodifiableMap(resolverConfigurations);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInitialised(String initialisingFor, OperationContext context) throws OperationFailedException {
        if (!this.initialised) {
            String existingInitialisation;
            if (this.firstFailure != null) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.expressionResolverInitialisationAlreadyFailed(this.firstFailure);
            }
            if (initialisingFor != null && (existingInitialisation = this.initialisingFor.get()) != null) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.cycleDetectedInitialisingExpressionResolver(existingInitialisation, existingInitialisation);
            }
            ElytronExpressionResolver elytronExpressionResolver = this;
            synchronized (elytronExpressionResolver) {
                if (!this.initialised) {
                    try {
                        this.initialisingFor.set(initialisingFor);
                        this.configurator.accept((Object)this, (Object)context);
                        this.initialised = true;
                    }
                    catch (OperationFailedException e) {
                        this.firstFailure = e;
                        throw e;
                    }
                    finally {
                        this.initialisingFor.set(null);
                    }
                }
            }
        }
    }

    public static class ResolverConfiguration {
        private final String credentialStore;
        private final String alias;

        public ResolverConfiguration(String credentialStore, String alias) {
            this.credentialStore = (String)Assert.checkNotNullParam((String)"credentialStore", (Object)credentialStore);
            this.alias = (String)Assert.checkNotNullParam((String)"alias", (Object)alias);
        }

        public String getCredentialStore() {
            return this.credentialStore;
        }

        public String getAlias() {
            return this.alias;
        }
    }
}

