/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.wst;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.parsers.AbstractParser;
import org.picketlink.common.util.StaxParserUtil;
import org.picketlink.identity.federation.core.parsers.wst.WSTRequestSecurityTokenCollectionParser;
import org.picketlink.identity.federation.core.parsers.wst.WSTRequestSecurityTokenParser;
import org.picketlink.identity.federation.core.parsers.wst.WSTRequestSecurityTokenResponseCollectionParser;
import org.picketlink.identity.federation.core.parsers.wst.WSTRequestSecurityTokenResponseParser;

public class WSTrustParser
extends AbstractParser {
    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader);
            if (xmlEvent instanceof StartElement) {
                StartElement startElement = (StartElement)xmlEvent;
                String elementName = StaxParserUtil.getStartElementName((StartElement)startElement);
                if (elementName.equalsIgnoreCase("RequestSecurityTokenCollection")) {
                    WSTRequestSecurityTokenCollectionParser wstrcoll = new WSTRequestSecurityTokenCollectionParser();
                    return wstrcoll.parse(xmlEventReader);
                }
                if (elementName.equalsIgnoreCase("RequestSecurityToken")) {
                    WSTRequestSecurityTokenParser wst = new WSTRequestSecurityTokenParser();
                    return wst.parse(xmlEventReader);
                }
                if (elementName.equalsIgnoreCase("RequestSecurityTokenResponseCollection")) {
                    WSTRequestSecurityTokenResponseCollectionParser wstrcoll = new WSTRequestSecurityTokenResponseCollectionParser();
                    return wstrcoll.parse(xmlEventReader);
                }
                if (elementName.equalsIgnoreCase("RequestSecurityTokenResponse")) {
                    WSTRequestSecurityTokenResponseParser wst = new WSTRequestSecurityTokenResponseParser();
                    return wst.parse(xmlEventReader);
                }
                throw logger.parserFailed(elementName);
            }
            StaxParserUtil.getNextEvent((XMLEventReader)xmlEventReader);
        }
        throw logger.parserFailed("http://docs.oasis-open.org/ws-sx/ws-trust/200512");
    }

    public boolean supports(QName qname) {
        return "http://docs.oasis-open.org/ws-sx/ws-trust/200512".equals(qname.getNamespaceURI());
    }
}

