/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.util.OptionalInt;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.wildfly.clustering.marshalling.protostream.FieldMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.ScalarMarshaller;

public class ScalarFieldMarshaller<T>
implements FieldMarshaller<T> {
    private final ScalarMarshaller<T> marshaller;

    public ScalarFieldMarshaller(ScalarMarshaller<T> marshaller) {
        this.marshaller = marshaller;
    }

    @Override
    public T readFrom(ProtoStreamReader reader) throws IOException {
        Object result = this.marshaller.readFrom(reader);
        boolean reading = true;
        while (reading) {
            int tag = reader.readTag();
            reading = tag != 0 && reader.skipField(tag);
        }
        return result;
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, T value) throws IOException {
        this.marshaller.writeTo(writer, value);
    }

    @Override
    public OptionalInt size(ImmutableSerializationContext context, T value) {
        return this.marshaller.size(context, value);
    }

    @Override
    public Class<? extends T> getJavaClass() {
        return this.marshaller.getJavaClass();
    }

    @Override
    public int getWireType() {
        return this.marshaller.getWireType();
    }
}

